#pragma once
#include "mbed.h"

#include "Color565.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"

#include "Shapes.h"
#include "Vector.h"
#include "Physics.h"

class Paddle
{
    public:
        Paddle(LCD_ST7735* pDisp);
        Paddle(LCD_ST7735* pDisp, int nX, int nY, int nWidth, int nHeight);
        void initialize(int nX, int nY, int nWidth, int nHeight);

     
        void move(Vector vDiff);
        void checkBoundary(Rectangle rBoundary);
        bool hasChanged();

        void clearPrev();
        void clear();
        void draw();
        void redraw(bool fForceDraw=false);

        Position pos;
        Dimension dim;
        Vector vSpeed;



    private:
        LCD_ST7735* pDisp;
};