#pragma once
#include "mbed.h"

#include "Color565.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"

#include "Shapes.h"

class Hole
{
    public:
        Hole();
        Hole(LCD_ST7735* pDisp);
        Hole(LCD_ST7735* pDisp, uint16_t uClr);
        void setColor(uint16_t uClr);
        void draw();
        void setCirc(Circle cNew);
        Circle getCirc();
        bool collides(Circle cObject);
        bool hasGoneIn(Circle cObject);

        bool fActive;

    protected:
        uint16_t dimmedColor(uint16_t uColor);

    private:
        uint16_t uColor;
        uint16_t uColorHigh;
        uint16_t uColorMid;
        uint16_t uColorLow;
        LCD_ST7735* pDisp;
        Circle cHole;        
};        