#include "Hole.h"

Hole::Hole() : cHole(0,0,0)
{   // constructor
}

Hole::Hole(LCD_ST7735* pDisp) : cHole(0,0,0)
{   // constructor
    this->pDisp=pDisp;
    setColor(Color565::Gray);
    this->fActive=false;
}

Hole::Hole(LCD_ST7735* pDisp, uint16_t uClr) : cHole(0,0,0)
{   // constructor
    this->pDisp=pDisp;
    setColor(uClr);
    this->fActive=false;
}

uint16_t Hole::dimmedColor(uint16_t uColor)
{
    uint16_t r, g, b;
   
    r=(uColor >> 11) <<3;
    g=((uColor >> 5) & 0x3F) <<2;
    b=(uColor & 0x1F) << 3;
    r=r*2/3;
    g=g*2/3;
    b=b*2/3;

    return(Color565::fromRGB((uint16_t)r,(uint16_t)g,(uint16_t)b));
}

void Hole::setColor(uint16_t uClr)
{
    uColor=uClr;
    this->uColorHigh=uColor;
    this->uColorMid=dimmedColor(uColorHigh);
    this->uColorLow=dimmedColor(uColorMid);
}



void Hole::setCirc(Circle cNew)
{
    cHole=cNew;
}


Circle Hole::getCirc()
{
    return(cHole);
}

bool Hole::collides(Circle cObject)
{
    // TODO: could be more precise
    Rectangle rHole=cHole.getBoundingRectangle();
    Rectangle rObject=cObject.getBoundingRectangle();

    return(rHole.collides(rObject));
}

bool Hole::hasGoneIn(Circle cObject)
{   // check if circular object has entered the hole
    Line l(cHole.getX(), cHole.getY(), cObject.getX(), cObject.getY());

    if(l.getSize()<=cHole.getRadius())
        return(true);
    return(false);
}

void Hole::draw()
{
    int x=cHole.getX();
    int y=cHole.getY();
    int r=cHole.getRadius();
    pDisp->fillCircle(x, y, r, this->uColorMid, this->uColorLow);
    pDisp->fillCircle(x+r/2-r/3, y+r/2-r/3, r-2, Color565::Black, Color565::Black);

/*
char szBuffer[256];
sprintf(szBuffer, "h:%d,%d - %d     ", cHole.getX(), cHole.getY(), cHole.getRadius());
pDisp->drawString(font_oem, 0, 0, szBuffer);
*/

}
