#pragma once
#include "mbed.h"

#include "Color565.h"
#include "LCD_ST7735.h"

class Accelerometer
{
    public:
        Accelerometer(int nI2cAddress, LCD_ST7735* pDisp);
        void getXYZ(double& x, double& y, double& z);
        void resetGraph();
        void updateGraph();

    private:
        static const int GRAPH_HEIGHT = 40;
        static const int GRAPH_SPACING = 2;

        void readRegisters(char address, char* buffer, int len);
        int writeRegister(char address, char value);
        double convert(char* buffer);

        int i2cAddress;
        I2C i2c;
        LCD_ST7735* pDisp;
        unsigned short colors[3];
        int graphX;    

        void drawAxes();
        void drawPoint(int axis, double value);
        void checkGraphReset();
};