#include "Wall.h"

Wall::Wall() : rWall(0,0,0,0)
{   // constructor
}

Wall::Wall(LCD_ST7735* pDisp) : rWall(0,0,0,0)
{   // constructor
    this->pDisp=pDisp;
    uColor=Color565::Blue;
    this->fActive=false;
}

Wall::Wall(LCD_ST7735* pDisp, uint16_t uClr) : rWall(0,0,0,0)
{   // constructor
    this->pDisp=pDisp;
    uColor=uClr;
    this->fActive=false;
}


void Wall::setRect(Rectangle rNew)
{
    rWall=rNew;
}


Rectangle Wall::getRect()
{
    return(rWall);
}

void Wall::draw()
{
    int x1=rWall.getX1();
    int y1=rWall.getY1();
    int x2=rWall.getX2();
    int y2=rWall.getY2();
    if(x1!=x2 && y1!=y2)
        pDisp->fillRect(x1,y1,x2,y2, uColor);
    else
        pDisp->drawLine(x1,y1,x2,y2, uColor);

/*
char szBuffer[256];
sprintf(szBuffer, "w:%d,%d - %d,%d     ", rWall.getX1(), rWall.getY1(), rWall.getX2(), rWall.getY2());
pDisp->drawString(font_oem, 0, 0, szBuffer);
*/

}

