#include "SoundFX.h"

SoundFX::SoundFX() : music(P0_18)
{
    this->fMute=false;
    music.setCompletionCallback(this, &SoundFX::musicCompleted);
}

void SoundFX::musicCompleted(void)
{

}

void SoundFX::reset()
{

}

void SoundFX::setMute(bool fMute)
{
    this->fMute=fMute;
}


bool SoundFX::getMute()
{
    return(this->fMute);
}


void SoundFX::beep(int nDuration)       //nDuration=1
{
    if(this->fMute)
        return;
    music.play("T240 L16 O6 C");
}

void SoundFX::beepShort()
{
    if(this->fMute)
        return;

    music.play("T240 L32 O6 C");
}

void SoundFX::beepLong()
{
    if(this->fMute)
        return;
    music.play("T240 L8 O5 C");
}

void SoundFX::beepLow()
{
    if(this->fMute)
        return;
    music.play("T180 L4 O3 C");
}

void SoundFX::play(char *szPlay)
{
    if(this->fMute)
        return;
    music.play(szPlay);
}

void SoundFX::playTune()
{
    if(this->fMute)
        return;
//    music.setCompletionCallback(this, &SoundFX::musicCompleted);
    music.play("T224L8O5CL16>C<P16GP16L8EL16P16>C<GP16L8E.L16P16L8C#L16>C#<P16G#P16L8FL16P16>C#<G#P16L8F.L16P16L8CL16>C<P16GP16L8EL16P16>C<GP16L8E.L16P16D#EFP16FF#GP16GG#AP16L8>C<P8L4>C");
}