#pragma once
#include "mbed.h"
#include "Vector.h"
#include "Shapes.h"

class Position
{
    public:
        Position();
        Point getPrev();
        Point getCur();
        int getX();
        int getY();

        void set(float x, float y);
        void set(int x, int y);
        void set(Point ptNew);
        void setX(int x);
        void setY(int y);

        void move(float fDiffX, float fDiffY);
        void move(int nDiffX, int nDiffY);
        void move(Vector vDiff);
        bool hasChanged();
    private:
        Vector vPos;
        Point pPrev;
        Point pCur;
};

class Dimension
{
    public:
        Dimension();
        int nWidth;
        int nHeight;
};