#include "Paddle.h"

Paddle::Paddle(LCD_ST7735* pDisp)
{   // constructor
    this->pDisp=pDisp;
}

Paddle::Paddle(LCD_ST7735* pDisp, int nX, int nY, int nWidth, int nHeight)
{   // constructor
    this->pos.set(nX, nY);
    this->dim.nWidth=nWidth;
    this->dim.nHeight=nHeight;
    this->pDisp=pDisp;
}

void Paddle::initialize(int nX, int nY, int nWidth, int nHeight)
{
    this->pos.set(nX, nY);
    this->dim.nWidth=nWidth;
    this->dim.nHeight=nHeight;
}

void Paddle::checkBoundary(Rectangle rBoundary)
{
    if(pos.getX()<rBoundary.getX1())
        pos.setX(rBoundary.getX1());
    if(pos.getX()+dim.nWidth>rBoundary.getX2())
        pos.setX(rBoundary.getX2()-dim.nWidth);
}

bool Paddle::hasChanged()
{
    return(pos.hasChanged());
}

void Paddle::move(Vector vDiff)
{
    this->pos.move(vDiff);
/*
char szBuffer[256];
sprintf(szBuffer, "p:%d,%d      ", pos.getX(), pos.getY());
this->pDisp->drawString(font_oem, 0, 0, szBuffer);
*/

}


void Paddle::clearPrev()
{
    Point p=pos.getPrev();
    this->pDisp->fillRect(p.getX(), p.getY(), p.getX()+dim.nWidth, p.getY()+dim.nHeight, Color565::Black);    
}

void Paddle::clear()
{
    Point p=pos.getCur();
    this->pDisp->fillRect(p.getX(), p.getY(), p.getX()+dim.nWidth, p.getY()+dim.nHeight, Color565::Black);    
}

void Paddle::draw()
{
    Point p=pos.getCur();
    this->pDisp->drawLine(p.getX(), p.getY()+dim.nHeight, p.getX()+dim.nWidth/3, p.getY(), Color565::Blue);
    this->pDisp->fillRect(p.getX()+dim.nWidth/3, p.getY(), p.getX()+dim.nWidth/3+dim.nWidth/3, p.getY()+dim.nHeight, Color565::Blue);
    this->pDisp->drawLine(p.getX()+dim.nWidth/3+dim.nWidth/3, p.getY(), p.getX()+dim.nWidth, p.getY()+dim.nHeight, Color565::Blue);
}

void Paddle::redraw(bool fForceDraw)        // fForceDraw=false
{   // redraw the paddle if its position has changed
    
    if(pos.hasChanged() || fForceDraw)
    {
        Point pPrev=pos.getPrev();
        Point pCur=pos.getCur();
        clearPrev();
        draw();
    }
}