#pragma once
#include "mbed.h"

#include "Color565.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"

#include "Shapes.h"
#include "Vector.h"
#include "Physics.h"

class Ball
{
    public:
        static const bool fFixed=false;
        bool fActive;

        Ball();
        Ball(LCD_ST7735* pDisp);
        void initialize(int X, int Y, int R, uint16_t uColor);
        void setSpeed(int X, int Y);
        void changeSpeed(bool fUp);
        void unmove();
        void update();
        void clear();
        void clearPrev();
        void draw();
        void redraw();
        
        Position pos;
        int nRadius;
        Vector vSpeed;

        Circle getBoundingCircle();
        bool collides(Rectangle r);
        bool collides(Circle cObject);
        bool collides(Line ln);
        void Bounce(Vector vBounce);
        void BounceAgainst(Vector vBounce);

    private:
        uint16_t uColor;
        uint16_t uColorHigh;
        uint16_t uColorMid;
        uint16_t uColorLow;
        LCD_ST7735* pDisp;

        uint16_t dimmedColor(uint16_t uColor);
};

