#pragma once
#include <stdarg.h>
#include <algorithm>        // required for min() and max(), see http://www.cplusplus.com/reference/algorithm/
#include "mbed.h"

#include "Color565.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"
#include "SoundFX.h"
#include "Accelerometer.h"
#include "Shapes.h"
#include "Ball.h"
#include "Paddle.h"


#define NUM_BALLS 3

class Game
{
    static const char* LOSE_1;
    static const char* LOSE_2;
    static const char* SPLASH_1;
    static const char* SPLASH_2;
    static const char* SPLASH_3;
    //char buf[256];
    
    //static const int BALL_RADIUS = 3;
    static const int BALL_RADIUS = 6;
    static const int PADDLE_WIDTH = 39;
    static const int PADDLE_HEIGHT = 4;
    static const int PADDLE_SPEED = 4;
    static const char I2C_ADDR = 0x1C << 1;

    DigitalIn left;
    DigitalIn right;
    DigitalIn down;
    DigitalIn up;
    DigitalIn square;
    DigitalIn circle; 
    DigitalOut led1;
    DigitalOut led2;
    AnalogIn ain;
    //I2C i2c;
    LCD_ST7735 disp;

    SoundFX snd;
    Accelerometer accel;
//    Timer tWait;    // timer used for tickcounts

    Vector vGravity;
    //Ball ball;
    Paddle paddle;
    Ball aBalls[NUM_BALLS];

    bool mode;
    int nBalls;
    int nScore;
    bool fDrawPaddle;
    bool fDrawTopWall;
    
    int nTopWall;

    bool lastUp;
    bool lastDown;
    int nGameTickDelay;     // delay during game-tick

    void initialize();
    
    void printDouble(double value, int x, int y);
    void drawString(const char* str, int y);
    void printf(int x, int y, const char *szFormat, ...);
    int checkTiltLeftRight();
    
    void initializePaddle();
    void updatePaddle();
    void redrawPaddle();
    void checkPaddle();

    void setNoBalls();
    void newBall();
    void updateBalls();
    void redrawBalls();
    int countBalls();
    void checkNumBalls();
    void checkBallsCollision();

    void redrawTopWall();
    void checkButtons();

    //void checkCollision();
    
    public:
        Game();
        
        void showSplashScreen();
        void tick();
};