#pragma once
#include <stdarg.h>
#include <algorithm>        // required for min() and max(), see http://www.cplusplus.com/reference/algorithm/
#include "mbed.h"

#include "Color565.h"
#include "font_OEM.h"
#include "LCD_ST7735.h"
#include "SoundFX.h"
#include "Accelerometer.h"
#include "Shapes.h"
#include "Ball.h"
#include "Wall.h"
#include "Hole.h"


#define NUM_WALLS 30
#define NUM_HOLES 20

class Game
{
    static const char* LOSE_1;
    static const char* LOSE_2;
    static const char* SPLASH_1;
    static const char* SPLASH_2;
    static const char* SPLASH_3;
    
    static const int BALL_RADIUS = 5;
    static const int HOLE_RADIUS = 6;
    static const char I2C_ADDR = 0x1C << 1;

    DigitalIn left;
    DigitalIn right;
    DigitalIn down;
    DigitalIn up;
    DigitalIn square;
    DigitalIn circle; 
    DigitalOut led1;
    DigitalOut led2;
    AnalogIn ain;
    LCD_ST7735 disp;

    SoundFX snd;
    Accelerometer accel;
    Timer tWait;    // timer used for tickcounts

    Vector vGravity;
    Vector vFriction;
    Ball ball;
    Wall aWalls[NUM_WALLS];
    Hole aHoles[NUM_HOLES];

    bool mode;
    int nTopWall;
    int nBalls;
    int nScore;

    bool lastUp;
    bool lastDown;
    int nGameTickDelay;     // delay during game-tick

    void printDouble(double value, int x, int y);
    
    void initialize();
    void initLevel();
    Point getGridPos(char *sPos);
    void addWall(char *sWall);
    void addWalls(char *sWalls);
    void drawWalls();
    void addHole(char *sHole);
    void addHoles(char *sHoles);
    void drawHoles();
    
    void drawString(const char* str, int y);

    void newBall();
    void updateBall();
    void redrawBall();
    void checkBallCollision();
    
    void checkTilt();
    void checkButtons();

    void printf(int x, int y, const char *szFormat, ...);
    void checkNumBalls();
    
    public:
        Game();
        
        void showSplashScreen();
        void tick();
};