/* Copyright (c) 2014 Shigenori Inoue, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "PseudoRTC.h"

PseudoRTC::PseudoRTC(void)
{
    year = 0;
    month = 1;
    day = 1;
    hour = 1;
    minute = 0;
    second = 0;
    unixtime = 0;
    t.attach(this, &PseudoRTC::tictoc, 1);
}

PseudoRTC::~PseudoRTC(void) {}


void PseudoRTC::setTime(int y, int mo, int d, int h, int mi, int s)
{
    /* Check the validity */
    if (month < 13 && day < 32 && hour < 24 && minute < 60 && second < 60)
    {
        year = y;
        month = mo;
        day = d;
        hour = h;
        minute = mi;
        second = s;
        unixtime=toUnixTime();
    }
}

void PseudoRTC::set_time(time_t thetime)
{
    unixtime=thetime;

    struct tm *ptm;
    ptm = localtime (&unixtime);

    second=ptm->tm_sec;
    minute=ptm->tm_min;
    hour=ptm->tm_hour;
    day=ptm->tm_mday;
    month=ptm->tm_mon+1;
    year=ptm->tm_year+1900;
}

time_t PseudoRTC::time(time_t* timer=NULL)
{
    if(timer!=NULL)
        *timer=unixtime;
    return(unixtime);
}

time_t PseudoRTC::addSeconds(int nSec)
{   // add (or substract) some seconds to the rtc to adjust time as needed
    this->set_time(unixtime+nSec);
    return(unixtime);
} 

int PseudoRTC::getYear(void)
{
    return year;
}

int PseudoRTC::getMonth(void)
{
    return month;
}

int PseudoRTC::getDay(void)
{
    return day;
}

int PseudoRTC::getHour(void)
{
    return hour;
}

int PseudoRTC::getMinute(void)
{
    return minute;
}

int PseudoRTC::getSecond(void)
{
    return second;
}

/****** private methods *******/
time_t PseudoRTC::toUnixTime(void)
{
    struct tm tms;
    /*
        tm_sec  int seconds after the minute    0-61*
        tm_min  int minutes after the hour  0-59
        tm_hour int hours since midnight    0-23
        tm_mday int day of the month    1-31
        tm_mon  int months since January    0-11
        tm_year int years since 1900    
        tm_wday int days since Sunday   0-6
        tm_yday int days since January 1    0-365
        tm_isdst    int Daylight Saving Time flag   
    */
    tms.tm_sec=second;
    tms.tm_min=minute;
    tms.tm_hour=hour;
    tms.tm_mday=day;
    tms.tm_mon=month-1;
    tms.tm_year=year-1900;
    return(mktime(&tms));
}

void PseudoRTC::tictoc(void)
{
    unixtime++;
    this->set_time(unixtime);   // update second, minute, hour, etc. member variables

/* old code    
    
    if(second < 59) {
        second++;
    } else {
        second = 0;
        minute++;
    }
    if(minute > 59) {
        minute = 0;
        hour++;
    }
    if(hour > 23) {
        hour = 0;
        day++;
    }
    if(day > 30 && (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12)) {
        day = 1;
        month++;
    }
    if(day > 29 && (month == 4 || month == 6 || month == 9 || month == 11)) {
        day = 1;
        month++;
    }
    if(day > 27 && month == 2) {
        day = 1;
        month++;
    }
    if(month > 12) {
        year++;
    }
*/
}