#include "mbed.h"
#include "BMP280.h"

#define BMP_TMP_ID 0x8
#define BMP_PRES_ID 0x9

Serial pc(USBTX, USBRX); // tx, rx
CAN can(p30,p29); //CAN
I2C i2c(p9,p10); //SDA, SCL
BMP280 bmp(i2c); //Default address = 0x76


int main() {
    
    //Serial config
    pc.baud(115200);
    pc.format(8, SerialBase::None, 1);
    pc.set_flow_control(SerialBase::Disabled, NC, NC);
    
    //CAN bus config
    can.frequency(125000); //125k Hz CAN bus speed
    can.reset();
    
    //bmp.initialize(); 
    
    float BMPTemp = 0;
    float BMPPressure = 0;
    
    while(1) {
        
        BMPTemp = (bmp.getTemperature() - 32) / 1.8f;
        BMPPressure = bmp.getPressure();
        pc.printf("Temp: %f, Pressure: %f\r\n",BMPTemp, BMPPressure);
        
        can.write(CANMessage(BMP_TMP_ID, (char*)&BMPTemp, sizeof(BMPTemp)/sizeof(char)));
        wait(0.1); //Need waits for some reason, without them the data doesnt always arrive in a neat order
        can.write(CANMessage(BMP_PRES_ID, (char*)&BMPPressure, sizeof(BMPPressure)/sizeof(char)));
        wait(0.1);
        
        
    }
}
