#include "INA219.h"

INA219::INA219(I2C& theI2C, char address)
    :i2c(theI2C), i2cAddress(address)
{
    init();
}

void INA219::init()
{
    //set up config register            //256 averages          //continuous shunt voltage conversion
    short write_byte = CONF_DEFAULT & ~_BV(BRNG);
    
    write(REG_CONF, write_byte);
    //set up calibration (full range ~5A)
    write(REG_CAL, 0x14F7);
}

void INA219::write(INA219REG reg, short value)
{
    shortToChar stc;
    char cmd[3];
    stc.u16 = value;
    
    cmd[0] = reg;
    cmd[1] = stc.u8[1];
    cmd[2] = stc.u8[0];
    
    i2c.write(i2cAddress,cmd,3);
}

short INA219::read(INA219REG reg)
{
    shortToChar stc;
    
    char cmd[2];
    cmd[0] = reg;
    i2c.write(i2cAddress,cmd,1);
    
    i2c.read(i2cAddress, cmd, 2);
    stc.u8[1] = cmd[0];
    stc.u8[0] = cmd[1];
    
    return (stc.u16);
}

float INA219::getCurrent()
{
    short curr = read(REG_CURR);
    return (float)curr / 6554;
}