/*
 * ina226.h
 *
 * driver for INA219 current monitor chip
 *
 * Created: 03/11/2015 17:13:11
 *  Author: Jack
 */ 


#ifndef INA219_H_
#define INA219_H_

#include "mbed.h"

#define INA219_1    0x40
#define INA219_2    0x41

/*
//INA226 register addresses
#define REG_CONF    0x00
#define REG_SHNT    0x01
#define REG_BUS     0x02
#define REG_PWR     0x03
#define REG_CURR    0x04
#define REG_CAL     0x05
*/
enum INA219REG
{
    REG_CONF=0x00,
    REG_SHNT=0x01,
    REG_BUS=0x02,
    REG_PWR=0x03,
    REG_CURR=0x04,
    REG_CAL=0x05,
};
//BITS
//CONFIG REGISTER
#define CONF_DEFAULT 0x399F

#define RST 15 //reset bit
#define BRNG 13 //bus voltage range: 0=16V, 1=32V
#define PG1 12 // PGA gain
#define PG0 11 // & range
#define BADC4 10 // bus adc resolution/averaging
#define BADC3 9 //
#define BADC2 8 //
#define BADC1 7 //
#define SADC4 6 // shunt adc resolution/averaging
#define SADC3 5 //
#define SADC2 4 //
#define SADC1 3 //
#define MODE3 2 // operating mode
#define MODE2 1 //
#define MODE1 0 //

#define _BV(bit) (1 << (bit))

/*
void ina226_init(I2C* i2c, char addr);
void ina226_write(I2C* i2c, char addr, char reg, short value);
short ina226_read(I2C* i2c, char addr, char reg);
*/

union shortToChar
{
    short u16;
    char u8[2];
};

class INA219
{
    public:
        INA219(I2C& theI2C, char address);
        void init();
        void write(INA219REG reg, short value);
        short read(INA219REG reg);
        float getCurrent();
    private:
        I2C& i2c;
        char i2cAddress;
};


#endif /* INA219_H_ */