#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"


BufferedSerial RFID(D1, D0, 9600); // initialisation de la liaison TX RX
//AnalogOut gache(A0);

int main()
{
    // variable de detection tactile   
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint16_t X, Y;
    uint8_t status;
    
    // init de la carte
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    HAL_Delay(1000);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) 
    {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } 
    else 
    {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    HAL_Delay(1000);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    
    // déclaration des variables 
    
    int cara1 = 0; // caractère du code pin
    int cara2 = 0;
    
    uint8_t tab1[5]; // stokage des caractères pour les cases
    uint8_t tab2[5];
    
    int code = 0;   // si code pin bon = 1
    int carteRFID = 0; // si pass bon = 1

    while(1) 
    {        
        // écriture des texte sur l'écran situer dans les bouttons
        
        BSP_LCD_DisplayStringAt(40,170  ,(uint8_t *)" 1 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(115,170  ,(uint8_t *)" 2 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(190,170  ,(uint8_t *)" 3 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(265,170  ,(uint8_t *)" 4 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(340,170  ,(uint8_t *)" 5 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(40,230  ,(uint8_t *)" 6 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(115,230  ,(uint8_t *)" 7 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(190,230  ,(uint8_t *)" 8 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(265,230  ,(uint8_t *)" 9 ", LEFT_MODE);
        BSP_LCD_DisplayStringAt(326,230  ,(uint8_t *)" CLEAR ", LEFT_MODE);
    
        //Creation des 2 zones du code pin 
        
        BSP_LCD_DrawRect(80,75,40,40);// zone 1
        BSP_LCD_DrawRect(150,75,40,40);// zone 2

        //Creation des bouttons 1 à 9 + clear
        
        BSP_LCD_DrawRect(25,150,50,50); // 1
        BSP_LCD_DrawRect(100,150,50,50);// 2
        BSP_LCD_DrawRect(175,150,50,50);// 3
        BSP_LCD_DrawRect(250,150,50,50);// 4
        BSP_LCD_DrawRect(325,150,50,50);// 5
        BSP_LCD_DrawRect(25,210,50,50);// 6
        BSP_LCD_DrawRect(100,210,50,50);// 7
        BSP_LCD_DrawRect(175,210,50,50);// 8
        BSP_LCD_DrawRect(250,210,50,50);// 9
        BSP_LCD_DrawRect(325,210,50,50);// clear
        
        BSP_LCD_DisplayStringAt(0,LINE(1),(uint8_t *)"PROJET GACHE, JANEZ MAXIME", CENTER_MODE);
        
        if(RFID.readable()) // lecture de la carte RFID
        {
            char buffer[100];
            RFID.read(buffer,100);
            printf("%s\r\n", buffer); 
            //BSP_LCD_DisplayStringAt(40,50  ,(uint8_t *)buffer, LEFT_MODE);
            
            if ( buffer[0] == '0' && buffer[1] == 'D' && buffer[2] == '0' && buffer [3] == '0')
            {
                carteRFID = 1;
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)" PASS CORRECT ", CENTER_MODE);
            }
            else 
            {
                carteRFID = 0;
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"PASS INCORRECT", CENTER_MODE);
            }   
        }

        // choix du 1er caractère du code pin
        
        if(cara1 == 0 && carteRFID == 1)
        {
            if (TS_State.touchDetected) 
            {
                if(X > 25 && X < 75)
               {
                    if(Y > 150 && Y < 200)
                    {
                        cara1 = 1;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 100 && X < 150)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara1 = 2;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 175 && X < 225)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara1 = 3;
                    }
                }
            }
            
            if (TS_State.touchDetected) 
            {
                if(X > 250 && X < 300)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara1 = 4;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 325 && X < 375)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara1 = 5;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 25 && X < 75)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara1 = 6;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 100 && X < 150)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara1 = 7;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 175 && X < 225)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara1 = 8;
                    }
                }
            }
            
            if (TS_State.touchDetected) 
            {
                if(X > 250 && X < 300)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara1 = 9;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 325 && X < 375)
                {
                    if(Y > 210 && Y < 260)
                    {
                        // clear des 2 caratères 
                        cara1 = 0;
                        cara2 = 0;
                    }
                }
            }
        }
    
        // écriture du 1er caractère dans la case 1
        sprintf((char*)tab1, "%d" , cara1);
        BSP_LCD_DisplayStringAt(95,95  ,(uint8_t *)&tab1, LEFT_MODE);
        
             
                // choix du 2nd caractère du code pin 

        if(cara1 != 0)
        {
            if (TS_State.touchDetected) 
            {
                if(X > 25 && X < 75)
               {
                    if(Y > 150 && Y < 200)
                    {
                        cara2 = 1;
                    }
                }
            }
            
            if (TS_State.touchDetected) 
            {
                if(X > 100 && X < 150)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara2 = 2;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 175 && X < 225)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara2 = 3;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 250 && X < 300)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara2 = 4;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 325 && X < 375)
                {
                    if(Y > 150 && Y < 200)
                    {
                        cara2 = 5;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 25 && X < 75)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara2 = 6;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 100 && X < 150)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara2 = 7;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 175 && X < 225)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara2 = 8;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 250 && X < 300)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara2 = 9;
                    }
                }
            }

            if (TS_State.touchDetected) 
            {
                if(X > 325 && X < 375)
                {
                    if(Y > 210 && Y < 260)
                    {
                        cara1 = 0;
                        cara2 = 0;
                    }
                }
            }
        }
                
        // écriture du 1er caractère dans la case 2
        sprintf((char*)tab2, "%d" , cara2);
        BSP_LCD_DisplayStringAt(170,95  ,(uint8_t *)&tab2, LEFT_MODE); 
    
        if (cara1 == 3 && cara2 == 9) // vérification du bon code pin
        {
            code = 1;
            if ( carteRFID == 1 && code == 1)  // si le pass + code bon 
            {
                //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"CODE BON, ACCES AUTORISER", CENTER_MODE);
                BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
                BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)" CODE CORRECT ", CENTER_MODE);
                //gache = 1;
                //HAL_Delay(1000);
                
            }  
        }
        else 
        {
            BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
            BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"CODE INCORRECT", CENTER_MODE);
        }
        // détection des cordonnées tactile
        BSP_TS_GetState(&TS_State);
        X = TS_State.touchX[0];
        Y = TS_State.touchY[0];       
    }
}
