#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"

I2C i2c(PB_9, PB_8);
DigitalOut buzzer(D11);

int main()
{
    uint8_t ADDR_6700 = 42;//Adresse du capteur
    char cmd[6] = {};
    char data[6] = {};//Variable de stockage des valeurs de Co2 du capteur
    char valeur[30];
    int readOk = 0;
    int msb = 0; //bit de poid fort
    int lsb = 0; //bit de poid faible
    int co2 = 0;
    int frequence = 100000;//frequence de l'horloge
    
    TS_StateTypeDef TS_State;
    uint16_t xRect = 215;
    uint16_t X, Y;
    uint8_t text[30];
    uint8_t textCo2[30];
    uint8_t status;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    
    int alarme = 0;
    int etatBp = 0;
    
    int sueil = 0;
    buzzer = 0;
    
    //Initialisation
    i2c.frequency(frequence);
    BSP_EEPROM_Init();
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    HAL_Delay(1000);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"INITIALISATION FAIL", CENTER_MODE);
    } else {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"INITIALISATION OK", CENTER_MODE);
    }
    
    
   

    HAL_Delay(1000);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
            
    while(1) {

        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            prev_nb_touches = TS_State.touchDetected;
            cleared = 0;
            }
        else {
            if (!cleared) {
                BSP_LCD_Clear(LCD_COLOR_BLACK);
                cleared = 1;
            }
        }
        //Recuperation de la position X et Y du doigt sur l'écran
        X = TS_State.touchX[0];
        Y = TS_State.touchY[0];
        
        //Creation du bouton STOP du signal sonor 
        BSP_LCD_DrawRect(10,210,100,50);
        BSP_LCD_DisplayStringAt(30,230,(uint8_t *)"STOP",LEFT_MODE);
        if (TS_State.touchDetected) {
            if(X > 10 && X < 110){
                if(Y > 210 && Y < 260){
                    alarme = 0;
                    etatBp = 1;
                    }
                }
            }
        
        //creation du slide
        sprintf((char*)text, "%d", sueil);
        BSP_LCD_DisplayStringAt(305,215,(uint8_t *)&text,LEFT_MODE);
        BSP_LCD_FillRect(210,235,200,10);
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_FillRect(xRect,230,10,20);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        if(TS_State.touchDetected){
            if(X > 215 && X < 395){
                if(Y > 230 && Y < 250){
                 xRect = X;
                 sueil = (400 + X) - 215;
                 }
            }
        }
        
        //I2C
        cmd[0] = 0x04;
        cmd[1] = 0x13;
        cmd[3] = 0x8B;
        cmd[4] = 0x00;
        cmd[5] = 0x01;
        //configuration du registre
        i2c.write(ADDR_6700, cmd, 6);
        HAL_Delay(7);
        //requete et recuperation de la valeur du CO2
        readOk = i2c.read(ADDR_6700, data, 5);
        HAL_Delay(10);
        //Calcul
        msb = (int)data[2];
        lsb = (int)data[3];
        co2 = msb * 256 + lsb;
        //Affichage de la valeur de Co2 et de la trame
        sprintf((char*)text, "%02X %02X %02X %02X %d", data[0], data[1], data[2], data[3], readOk);
        BSP_LCD_DisplayStringAt(305,170,(uint8_t *)&text,LEFT_MODE);
        sprintf(valeur, "%d ppm", co2);
        BSP_LCD_DisplayStringAt(305,190,(uint8_t *)&valeur,LEFT_MODE);

        //Gestoin de l'alarme  
        //premier niveau d'alerte      
        if(co2 >= sueil && co2 < 1500){
            alarme = 1;
            //Indication du niveau de danger à l'utilisateur
            BSP_LCD_DisplayStringAt(200,100,(uint8_t *)"Attention, il faut ouvrir les fenetre",LEFT_MODE);
            if(etatBp != 0){
                alarme = 0;
            }
        }
        //deuxième niveau d'alerte
        else if(co2 >= 1500){
            alarme = 2;
            //Indication du niveau de danger à l'utilisateur
            BSP_LCD_DisplayStringAt(308,100,(uint8_t *)"Evacuer la salle",LEFT_MODE);
            if(etatBp != 0){
                alarme = 0;
            }               
        }  
        else if(co2 < sueil){
            alarme = 0;
            etatBp = 0;
            //Indication du niveau de danger à l'utilisateur                 
            BSP_LCD_DisplayStringAt(308,100,(uint8_t *)"Aucun danger",LEFT_MODE);
        }
        
        switch(alarme){
            // signal sonor éteinte
            case 0:
                buzzer = 0;
            break;
            // signal sonor discontinu
            case 1:
                buzzer = 1;
                HAL_Delay(500);
                buzzer = 0;
            break;
            // signal sonor continu
            case 2:
                buzzer = 1;
            break;
        }
    }
}

