#include "mbed.h"
#include "USBSerial.h"
Ticker tick;                                                                //

AnalogIn linear_position(A0);                                               //sets an analog input to receive the linear position
AnalogIn linear_velocity(A1);                                               //sets an analog input to receive the linear velocity

USBSerial u_s_b;
//Serial pc(USBTX, USBRX);                                                    //enable usb serial communication
//Serial encoder(PTE0, PTE1);
DigitalOut red(LED_RED);                                                    //set the red LED as red
DigitalOut green(LED_GREEN);                                                //set the green LED as green
DigitalOut blue(LED_BLUE);                                                  //set the blue LED as blue
DigitalOut ms(PTD1);                                                        //set the transceiver mode selection (0=receiver mode and 1=transmiter mode) 

volatile uint8_t received1, received2, address = 0x54;                      //angle components variables
volatile uint16_t angle = 0;                                                //encoder angle

void isr()                                                                  //interrupution routine
{/*
    u_s_b.printf("0x%04X",linear_position.read_u16());                         //send linear position, obs: 6 chars needed
    u_s_b.printf("0x%04X",linear_velocity.read_u16());                         //send linear velocity
    u_s_b.printf("0x%04X",angle);                                              //send angle
    u_s_b.printf("OMEGA ");                                                    //send angular velocity 
*/}

int main()                                                                  //main function
{
    
    //PC serial communication
//    pc.baud(115200);                                                        //set baud rate
    //encoder.baud(115200);
//    tick.attach(&isr, 1);                                                   //setup ticker to call isr every 0.1s seconds
    

    //Encoder serial communication
    SIM->SCGC5 |= 0x00000200;                                               //enable PORTA clock
    PORTA->PCR[1] |= 0x00000200;                                            //PTA0 as ALT2 (UART0) 
    PORTA->PCR[2] |= 0x00000200;                                            //PTA1 as ALT2 (UART0) 
    SIM->SOPT2 |= 0x04000000;                                              //select MCGFLLCLK as the UART0 clock source (24M by default)
    SIM->SOPT5 &= 0x00000000;                                              //select UART0 TX pin as UART0 TX source and UART0 RX pin as UART0 RX source
    SIM->SCGC4 |= 0x00000400;                                               //enable UART0 clock

    
    //baud rate divider setting:
    //BAUD = Bus_Clock/((OSR+1) x BR) = 24M/ ((3+1) x 3) = 2M
    
    UART0->BDH = 0x00;                                                      //set the highest bits of the baud rate divider
    UART0->BDL = 0x06;                                                      //set the lowest bits of the baud rate divider
    UART0->C4  = 0x03;                                                      //sets the Over Sampling Ratio (OSR) - MUST BE SET BEFORE C2
    UART0->C5  = 0x00;                                                      //sets both edges sampling - MUST BE SET BEFORE C2 AND IF OSR>7
    UART0->C1  = 0x00;                                                      //sets a 8N1 configuration
    UART0->C2  = 0x0C;                                                      //enables Tx and Rx/ Interrupts disabled

    red = 1;                                                                //turn off the red LED
    green = 1;                                                              //turn off the green LED
    blue = 1;                                                               //turn off the blue LED
    while (true)                                                            //infinite loop
    {
            
        if (((UART0->S1&0xC0)>>6)==0x03)                                    //if the ucontroller transmiter buffer is free
        {
            ms = 1;                                                         //put the transceiver in the transmiter mode
            UART0->D = 0x54;                                                //send the encoder's address
            while(!(((UART0->S1&0xC0)>>6)==0x03));                          //wait 'til the message has been completely sent
            ms = 0;                                                         //put the transceiver in the receiver mode
        }
        
        red = 1;
        //wait_us(1);
        //while(!(((UART0->S1&0x20)>>5)==0x01));
        
        if(((UART0->S1&0x20)>>5)==0x01)                                         //if the ucontroller receiver buffer is full
            {
                received1 = UART0->D;      
                if (((UART0->S1&0x08)>>3)==0x01)                                            //if an overflow happened
                    {
                        received2 = 0x63;
                        UART0->S1=1;                                            
                    }
                    else
                        received2 = 0x64;                                 //stores the first Byte in the received1 variable
                //                      //- NÃO SAI DO LOOP -wait 'til the next has been received
                //if(((UART0->S1&0x20)>>5)==0x01)
                //wait_us(6);
                //if(((UART0->S1&0x20)>>5)==0x01)
                //    received2 = UART0->D;
                //else if (((UART0->S1&0x08)>>3)==0x01)                                            //if an overflow happened
                //    {
                //        received2 = 0x63;
                //        UART0->S1=1;                                            
                //    }
                //    else
                //        received2 = 0x64;
                //received2 = UART0->D;
                                                       //stores the second Byte in the received2 variable
                    
                angle = ((((received2)&0x3F)<<8)|(received1));          //assembly the angle using the components
            } 
            
        if (((UART0->S1&0x08)>>3)==0x01)                                            //if an overflow happened
        {
            UART0->S1=1;                                            
        }
        
        u_s_b.printf("0x%04X",linear_position.read_u16());                         //send linear position, obs: 6 chars needed
        u_s_b.printf("0x%04X",linear_velocity.read_u16());                         //send linear velocity
        u_s_b.printf("0x%04X",angle);                                              //send angle
        u_s_b.printf("OMEGA ");                                                    //send angular velocity 
    }
}
//TO DO: verificar se ocorr overflow do buffer
