#include "mbed.h"


Ticker tick;                                                                //

AnalogIn linear_position(A0);                                               //sets an analog input to receive the linear position
AnalogIn linear_velocity(A1);                                               //sets an analog input to receive the linear velocity

Serial pc(USBTX, USBRX);                                                    //enable usb serial communication
//Serial encoder(PTE0, PTE1);
DigitalOut red(LED_RED);                                                    //set the red LED as red
DigitalOut green(LED_GREEN);                                                //set the green LED as green
DigitalOut blue(LED_BLUE);                                                  //set the blue LED as blue
DigitalOut ms(PTD1);                                                        //set the transceiver mode selection (0=receiver mode and 1=transmiter mode) 

volatile uint8_t received1, received2;                                      //angle components variables
volatile uint16_t angle = 0;                                                //encoder angle

void isr()                                                                  //interrupution routine
{
    pc.printf("0x%04X",linear_position.read_u16());                         //send linear position, obs: 6 chars needed
    pc.printf("0x%04X",linear_velocity.read_u16());                         //send linear velocity
    pc.printf("0x%04X",angle);                                              //send angle
    pc.printf("OMEGA ");                                                    //send angular velocity 
}

int main()                                                                  //main function
{

    //PC serial communication
    pc.baud(115200);                                                        //set baud rate
    //encoder.baud(115200);
    tick.attach(&isr, 1);                                                   //setup ticker to call isr every 0.1s seconds
    
    //Encoder serial communication
    SIM->SCGC5 |= 0x00002000;                                               //enable PORTE clock
    PORTE->PCR[0] |= 0x00000300;                                            //PTE0 as ALT3 (UART1) 
    PORTE->PCR[1] |= 0x00000300;                                            //PTE1 as ALT3 (UART1) 
    SIM->SCGC4 |= 0x00000800;                                               //enable UART1 clock
    SIM->SOPT5 &= ~0x00000070;                                              //select UART1 TX pin as UART1 TX source and UART1 RX pin as UART1 RX source
    
    
    /*baud rate divider setting:
     BAUD = Bus_Clock/(16 x BR) = 24M/ (16 x 13) ~ 115200
     baud rate values:       115200, 39400,   19200,   9600
     respective BDL values:    0x0D,  0x27,    0x4E,    0x9C*/
    
    UART1->BDH = 0x00;                                                      //set the highest bits of the baud rate divider
    UART1->BDL = 0x0D;                                                      //set the lowest bits of the baud rate divider
    UART1->C1  = 0x00;                                                      //sets a 8N1 configuration
    UART1->C2  = 0x0C;                                                      //enables Tx and Rx/ Interrupts disabled
    
    red = 1;                                                                //turn off the red LED
    green = 1;                                                              //turn off the green LED
    blue = 1;                                                               //turn off the blue LED
    while (true)                                                            //infinite loop
    {
        
        if (((UART1->S1&0xC0)>>6)==0x03)                                    //if the ucontroller transmiter buffer is free
        {
            ms = 1;                                                         //put the transceiver in the transmiter mode
            UART1->D = 0x54;                                                //send the encoder's address
            while(!(((UART1->S1&0xC0)>>6)==0x03));                          //wait 'til the message has been completely sent
            ms = 0;                                                         //put the transceiver in the receiver mode
        }
        
        wait_us(10);                                                        //turnaround time: 3us             10us                30us    56us    100us
                                                                            //baud rate:       115200(default) 115200(adjustable)  38400   19200   9600

        if(((UART1->S1&0x20)>>5)==0x01)                                     //if the ucontroller transmiter buffer is full
            {
                received1 = UART1->D;                                       //stores the first Byte in the received1 variable
                while(!(((UART1->S1&0x20)>>5)==0x01));                      //wait 'til the next has been received
                if(((UART1->S1&0x20)>>5)==0x01)                             //if the ucontroller transmiter buffer is full
                {
                    received2 = UART1->D;                                   //stores the second Byte in the received2 variable
                    angle = ((received1)|(((received2)&0x3F)<<8));          //assembly the angle using the components
                }
            }
/*
        if (((UART1->S1&0x20)>>5)==0x01)
            {
                received = UART1->D;
                angle = (received<<2);
                red = !red;
            }
*/
    }
}
//TO DO: Program the readings