/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "MFRC522.h"

#define SLEEP_TIME                  500 // (msec)
#define PRINT_AFTER_N_LOOPS         20

// K64F Pin for "MFRC522 (Chip select, Clock, MOSI, MISO,  IRQ, Ground, Reset, 3.3V)"
#define MF_RESET    D7  //Reset
#define SPI_MOSI    D11   //MOSI
#define SPI_MISO    D12   //MISO
#define SPI_SCK     D13  //Clock
#define SPI_CS      D9  //Chip Select

DigitalOut LedGreen(LED1);
Serial pc(USBTX, USBRX);
MFRC522 RfChip  (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);





// main() runs in its own thread in the OS
int main()
{
    pc.baud(9600);
    pc.printf("\r\n*********************Initialization**********************************");
    RfChip.PCD_Init();           /* Init. RC522 Chip*/
    pc.printf("\r\n**********************Starting Reading Tags**************************");   
       
    while (true) {
        LedGreen = 1;
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    // Select one of the cards
    if (!RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      pc.printf("\r\nReading a card");
      continue;
    }

    LedGreen = 0;

    // Print Card UID
    pc.printf("\r\nCard UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    pc.printf("\r\n");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \r\n", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);

    }
}
