#include "mbed.h"
#include "uLCD_4DGL.h"
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <cmath>
#include <string>
#include <sstream>
#include "SDFileSystem.h"
#include "wave_player.h"
#include "rtos.h"

SDFileSystem sd(p5, p6, p7, p8, "sd");

AnalogOut DACout(p18);

wave_player waver(&DACout);
FILE *wave_file;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
//Mutex lcd_mutex;
uLCD_4DGL uLCD(p9,p10,p11);


//class for navigation switch/digital joystick
class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();

    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();

    operator int ();

    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;

};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp);
    wait(0.001);
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}

Nav_Switch myNav( p16, p13, p14, p12, p15);

int value1, value2, op, answer;
int value = 0;
string userAns, strAns;
int gameCount = 0;
int points =0;

void RunGame();
void getAns();
void checkAns();
void win();
void lose();



//WIN SEQUENCE
void win()
{
    //lcd_mutex.lock();
    //uLCD.printf("Change baudrate......");
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    uLCD.background_color(WHITE); //background color white
    uLCD.cls();
    uLCD.pixel(60, 60, BLACK);
    uLCD.read_pixel(120, 70);
    uLCD.set_font(FONT_7X8);
    uLCD.text_mode(TRANSPARENT);
    uLCD.text_bold(ON);
    uLCD.text_char('Y', 4, 13, BLACK); //text "YOU WON" stays written
    uLCD.text_char('O',5, 13, BLACK);
    uLCD.text_char('U',6, 13, BLACK);
    uLCD.text_char('W', 8, 13, BLACK);
    uLCD.text_char('O',9, 13, BLACK);
    uLCD.text_char('N',10, 13, BLACK);
    for(int i=0; i<3; i++) { //movement repeats twice
        uLCD.filled_circle(30, 30, 15, 0xFF00FF); //draw balloons
        uLCD.filled_circle(60, 60, 15, 0xFF00FF);
        uLCD.filled_circle(100, 30, 15, 0xFF00FF);
        uLCD.line(30, 30, 30, 80, 0xFF00FF);
        uLCD.line(60, 60, 60, 110, 0xFF00FF);
        uLCD.line(100, 30, 100, 80, 0xFF00FF);
        wait(0.5);
        uLCD.filled_circle(30, 30, 15, 0xFFFFFF); // 'erase' balloons
        uLCD.filled_circle(60, 60, 15, 0xFFFFFF);
        uLCD.filled_circle(100, 30, 15, 0xFFFFFF);
        uLCD.line(30, 30, 30, 80, 0xFFFFFF);
        uLCD.line(60, 60, 60, 110, 0xFFFFFF);
        uLCD.line(100, 30, 100, 80, 0xFFFFFF);
        wait(0.5);
        uLCD.filled_circle(15, 30, 15, 0xFF00FF); //move ballons to new position
        uLCD.filled_circle(60, 50, 15, 0xFF00FF);
        uLCD.filled_circle(85, 30, 15, 0xFF00FF);
        uLCD.line(15, 30, 30, 80, 0xFF00FF);
        uLCD.line(60, 50, 60, 110, 0xFF00FF);
        uLCD.line(85, 30, 100, 80, 0xFF00FF);
        wait(0.5);
        uLCD.filled_circle(15, 30, 15,0xFFFFFF); //erase balloons in new position
        uLCD.filled_circle(60, 50, 15, 0xFFFFFF);
        uLCD.filled_circle(85, 30, 15, 0xFFFFFF);
        uLCD.line(15, 30, 30, 80, 0xFFFFFF);
        uLCD.line(60, 50, 60, 110, 0xFFFFFF);
        uLCD.line(85, 30, 100, 80, 0xFFFFFF);
        wait(0.5);
    }
    wave_file=fopen("/sd/wavfiles/fanfare2.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
   // lcd_mutex.unlock();
}

void lose()
{
        uLCD.cls();
        uLCD.background_color(0xFFFFFF);
        uLCD.baudrate(3000000);
        uLCD.set_font(FONT_7X8);
        uLCD.text_mode(TRANSPARENT);
        uLCD.text_bold(ON);
        uLCD.text_char('Y', 4, 13, WHITE); //text "YOU LOST" stays written
        uLCD.text_char('O',5, 13, WHITE);
        uLCD.text_char('U',6, 13, WHITE);
        uLCD.text_char('L', 8, 13, WHITE);
        uLCD.text_char('O',9, 13, WHITE);
        uLCD.text_char('S',10, 13, WHITE);
        uLCD.text_char('T',11, 13, WHITE);
        uLCD.filled_circle(60, 60, 30, 0xFF00FF); //draw balloon
        uLCD.line(60, 60, 60, 110, 0xFF00FF); // draw string
        uLCD.line(0, 0, 20, 20, WHITE); // draw needle
        wait(0.5);
        uLCD.line(0, 0, 20, 20, BLACK);
        wait(0.5);
        uLCD.line(10, 10, 20, 20, WHITE); //move needle
        wait(0.5);
        uLCD.line(10, 10, 20, 20, BLACK);
        wait(0.5);
        uLCD.line(20, 20, 30, 30, WHITE); //move needle
        wait(0.5);
        uLCD.line(20, 20, 30, 30, BLACK);
        wait(0.5);
        uLCD.line(30, 30, 40, 40, WHITE); //move needle
        wait(0.5);
        uLCD.filled_circle(60, 60, 30, BLACK); //erase ballon
        uLCD.line(60, 60, 60, 110, BLACK); //erase string
        wait(0.5);
        uLCD.line(30, 30, 40, 40, BLACK); //erase needle
        wait(0.5);
        uLCD.line(30, 60, 90, 60, 0xFF00FF); // draw "popped" lines
        uLCD.line(60, 30, 60, 90, 0xFF00FF);
        uLCD.line(60,60,30,30,0xFF00FF);
        uLCD.line(60,60,90,30,0xFF00FF);
        uLCD.line(60,60,30,90,0xFF00FF);
        uLCD.line(60,60,90,90,0xFF00FF);
        wait(0.5);
        uLCD.cls(); //erase screen 
        wave_file=fopen("/sd/wavfiles/sadtrombone.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
} 

int main()
{
    srand (time(NULL));
    RunGame();
    
}


//This function generates three random values based on the time. The first
//two values represent the two integers between 1 and 100 used for the equation
//and the third value between 1 and 4 is used decide the operation.
//1 - addition, 2 - sutraction, 3 - multiplication, 4 - division
void RunGame()
{
    gameCount++;
    uLCD.cls();
    uLCD.printf("hello");

    value1 = rand() % 100 + 1;
    value2 = rand() % 100 + 1;
    op = rand() % 4 + 1;
    //value1=10;
    //value2=5;
    //op=1;

    switch ( op ) {
        case 1:
            uLCD.printf("%d + %d", value1, value2);
            answer = value1 + value2;
            break;
        case 2:
            if (value1 <= value2) {
                uLCD.printf("%d - %d", value2, value1);
                answer = value2 - value1;
            }
            if (value1 > value2) {
                uLCD.printf("%d - %d", value1, value2);
                answer = value1 - value2;
            }
            break;
        case 3:
            uLCD.printf("%d * %d", value1, value2);
            answer = value1 * value2;
            break;
        case 4:
            uLCD.printf("%d / %d; Round to nearest integer", value1, value2);
            //answer = round(value1 / value2);
            answer = (value1 / value2);
            break;
        default:
            break;
    }
    strAns = static_cast<ostringstream*>( &(ostringstream() << answer) )->str();
    uLCD.printf("\nGive answer %s\n", strAns);
    getAns();
}


//The internal pushbuttons in the navigation switch are used to select each digit
//of the answer. The up pushbutton is used to increment digits, the down button
//is used to go to the next digit and the left is used to indicate that the user
//has finished answering. Since the navigation switch’s pushbuttons are highly
//sensitive to user movements and hence is hard to control, the right pushbutton
//is used to clear the answer value entered. The screen gets cleared with the
//equation that needs to be solved displayed at the top and the user is given
//another chance to input the answer.
void getAns()
{
    while(1) {
        if (myNav.up()) {
            value++;
            wait(.1);
            uLCD.printf("value %d\n", value);
        }
        if (myNav.down()) {
            string strValue = static_cast<ostringstream*>( &(ostringstream() << value) )->str();
            wait(.1);
            userAns = userAns + strValue;
            uLCD.printf("userans %s\n", userAns);
            value = 0;
        }
        if (myNav.left()) {
            uLCD.printf("This is your answer. %s\nThis is actual %s\n", userAns, strAns);
            wait(.1);
            checkAns();
        }
        if (myNav.right()) {
            value = 0;
            wait(.1);
            userAns = "";
            uLCD.cls();
            switch ( op ) {
                case 1:
                    uLCD.printf("%d + %d", value1, value2);
                    break;
                case 2:
                    if (value1 <= value2) {
                        uLCD.printf("%d - %d", value2, value1);
                    }
                    if (value1 > value2) {
                        uLCD.printf("%d - %d", value1, value2);
                    }
                    break;
                case 3:
                    uLCD.printf("%d * %d", value1, value2);
                    break;
                case 4:
                    uLCD.printf("%d / %d; Round to nearest integer", value1, value2);
                    break;
            }
        }
    }
}


//Checks if the answer that the user inputted is correct and a message is displayed accordingly.
//If 3 out of 5 problems were solved correctly, the user wins. A function for the graphic and
//effects are then called.
void checkAns()
{
    if (userAns == strAns) {
        uLCD.printf("Thats right!\n");
        points++;
        //win();
    } else {
        uLCD.printf("Thats wrong!\n");
        //lose();
    }
    wait(10);
    userAns = "";
    if (gameCount == 5) {
        if (points >= 3) {
            win();
        } else {
            lose();   
        }
    } else {
        RunGame();
    }
}
