#include "mbed.h"
#include "EthernetInterface.h"
#include "PinDetect.h"
#include <string>
#include "BufferedSoftSerial.h"

// Network interface
EthernetInterface net;
Thread thdFindConnection;
TCPSocket socket;
Thread thdStartProccess;
#define IP         "192.168.0.5"
#define GATEWAY    "192.168.1.1"
#define MASK       "255.255.255.0"

#include "mbed.h"

DigitalOut Led1(D7);
DigitalOut Led2(D6);
DigitalOut Led3(D5);

PinDetect  pin1( PTC0 );
PinDetect  pin2( PTC5 );

BufferedSoftSerial device(PTD1,PTD3);

Thread thdLedControl;

int step = 1;
bool PB1Pressed = false;
bool isConnected = false;

char cmdCheckConn[] = {0x0E, 0x0D, 0x31, 0x37, 0x30, 0x30, 0x30, 0x36, 0x30, 0x30, 0x30, 0x39, 0x35, 0x32};
char cmdReady[] = {0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F};

char cmdRun[] = {0x0C, 0x5F};

char cmdCompareData1[] = {0x30, 0x39, 0x35};

void ReconnectToServer()
{

    int i = net.set_network(IP,MASK,GATEWAY);
    i = net.connect();

    // Show the network address
    const char *ip = net.get_ip_address();

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    socket.open(&net);
    socket.connect("192.168.0.89", 5500);

    isConnected = true;
}

void LedControl()
{

    while(1) {
        switch(step) {
            case 1: {
                Led2 = 1;
                Led3 = 1;
                while(step == 1) {
                    Led1 = !Led1;
                    wait(0.5);
                }
            }
            break;

            case 2: {
                Led1 = 0;
                Led3 = 1;
                while(step == 2) {
                    Led2 = !Led2;
                    wait(0.5);
                }
            }
            break;

            case 3: {
                Led1 = 0;
                Led2 = 0;
                while(step == 3) {
                    Led3 = !Led3;
                    wait(0.5);
                }
            }
            break;
        }
    }
}

void DC_TCP()
{
    socket.close();
    net.disconnect();

    isConnected = false;
}

void keyReleased()
{
    if(step == 2) {
        if(!PB1Pressed) {
            PB1Pressed = true;
        }
    }
}

void StartProccess()
{

    while(1) {

        switch(step) {
            case 1: {

                char rbuffer[64];

                int rcount = socket.recv(rbuffer, sizeof rbuffer);
                if(rcount < 0) {
                
                } else if(rcount > 0) {
                    rbuffer[rcount] = '\0';

                    string data;

                    for(int i = 0; i<sizeof(rbuffer); i++) {
                        if(rbuffer[i] == '\0')break;
                        data += rbuffer[i];
                    }

                    if(data == "F01") {
                        step = 2;
                        printf("Measurring Process is Getting Started..\r\n");
                    }
                } else if(rcount == 0) {
                    printf("rcount = %d \r\n",rcount);
                }

            }
            break;

            case 2: {
                if(PB1Pressed) {
                    step = 3;

                    //Serial Comm Start;
                    printf("Measurring Process Starting.. \r\n");


                    device.printf("Helo Maul");
                }

            }
            break;

            case 3: {
                char buffer[256];
                string data;

                bool Done = false;
                int sbuff = 0;
                while(!Done) {

                    int state = 0;
                    char data1[3];
                    char data2[20];
                    char data3[256];
                    int datacount = 0;

                    switch(state) {
                        case 0: {

                            while(device.readable()) {
                                wait(0.01);
                                char tempbuf = device.getc();
                                data1[datacount] = tempbuf;

                                datacount++;
                            }

                            if(datacount == 3) {

                                bool equals = false;

                                if(data1[0] == '0' && data1[1] == '9' && data1[2] == '5') equals = true;

//                                if(data1[0] == '0')
//                                    equals = true;
//
//                                if(data1[1] == '9')
//                                    equals = true;
//
//                                if(data1[2] == '5')
//                                    equals = true;

                                if(equals) {
                                    state = 1;
                                    datacount = 1;
                                    printf("state %d finish\r\n",state);
                                }
                            }
                        }
                        break;

                        case 1: {
                            if(device.readable()) {
                                char tempbuf = device.getc();
                                data2[datacount-1] = tempbuf;
                                datacount++;
                            }

                            if(datacount == 10) {
                                if(data2[0] == 0x5E) {
                                    state = 2;
                                    datacount = 0;
                                    printf("state %d finish",state);
                                }
                            }
                        }
                        break;

                        case 3: {
                            if(device.readable()) {
                                char tempbuf = device.getc();
                                data3[datacount-1] = tempbuf;
                                datacount++;
                            }

                            if(datacount > 48) {
                                if(data3[datacount-1] == 0x30 && data3[datacount-2] == 0x05E) {
                                    state = 3;
                                    datacount = 0;

                                    for(int i = 0; i<data3[datacount-1]; i++) {
                                        printf("%c",data3[i]);

                                        if(i == datacount-1) {
                                            printf("\r\n");
                                        }
                                    }
                                    Done = true;
                                    step = 1;
                                    PB1Pressed = false;
                                    printf("Measurring Finish.. \r\n");
                                    printf("state %d finish",state);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }
}


void FindingServer()
{
    printf("Finding Server.....\r\n\r\n");
    int i = net.set_network(IP,MASK,GATEWAY);
    i = net.connect();

    // Show the network address
    const char *ip = net.get_ip_address();

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    socket.open(&net);
    socket.connect("192.168.0.89", 5500);
    isConnected = true;
    printf("Connected to Server....\r\n");
    thdStartProccess.start(StartProccess);
}

// Socket demo
int main()
{
    device.baud(9600);

    pin1.mode( PullDown );
    pin1.attach_deasserted( &keyReleased );
    pin1.setSampleFrequency(); // Defaults to 20ms.

    pin2.mode( PullDown );
    pin2.attach_deasserted( &keyReleased );
    pin2.setSampleFrequency(); // Defaults to 20ms.

    wait(0.01);
    thdFindConnection.start(FindingServer);
    thdLedControl.start(LedControl);
}
