/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "rtos.h"
#include <errno.h>
#include <stdio.h>
#include <vector>

// Block devices
//#include "SPIFBlockDevice.h"
//#include "DataFlashBlockDevice.h"
#include "SDBlockDevice.h"
//#include "HeapBlockDevice.h"

// File systems

//#include "LittleFileSystem.h"
#include "FATFileSystem.h"

Thread thread;
#define STOP_FLAG 1
DigitalOut led1(PC_13);

// Physical block device, can be any device that supports the BlockDevice API
SDBlockDevice blockDevice(PA_7, PA_6, PA_5, PA_4); // mosi, miso, sck, cs
Serial pc(PB_10, PB_11);
// File system declaration
FATFileSystem fileSystem("fs");

//AnalogIn pot(PA_3);  // PB_1
DigitalIn mypin(PB_1); // PA_2
//InterruptIn mypin(D1); // PA_2

static bool myflag = false;
static bool rain_flag = false;  // inicia False - No esta lloviendo
static bool timer_rain = false; // inicia False - No esta lloviendo
static bool tick_count =    false; // bandera para indicar que ha pasado un minuto de medicion
static bool timer60s = false;
// LowPowerTicker flipper;
Timeout flipper;
Timeout flipper2;

long pos;
FILE *f;
int err;

int number1;

void flip()
{
    tick_count = true;
}
void flip2()
{
    timer_rain = true;
}

void timer60seg()
{
    timer60s = true;
}

// Entry point for the example
int main()
{
    char command[8]; 
    int rain;
    int estado;
    uint16_t analog_sensor;
    rain = 0;
    estado = 3;


    //mypin.rise(&tip_interrup);  // attach the address of the flip function to the rising edge

    pc.printf("--- Mbed OS filesystem example ---\n");

    // Try to mount the filesystem
    pc.printf("Mounting the filesystem... ");
    fflush(stdout);

    err = fileSystem.mount(&blockDevice);
    pc.printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        pc.printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fileSystem.reformat(&blockDevice);
        pc.printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    pc.printf("Opening \"/fs/pluv.txt\"... ");
    fflush(stdout);

    f = fopen("/fs/pluv.txt", "r+");
    pc.printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the .txt file if it doesn't exist
        pc.printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/pluv.txt", "w+");
        pc.printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
        ////////////////////////////////////////
        err = fprintf(f, "\nInciando SD por primera ves\n");
        if (err < 0) {
            pc.printf("Fail :(\n");
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
        ///////////////////////////////////////
        /*
        for (int i = 0; i < 5; i++) {
          pc.printf("\rWriting pluv (%d/%d)... ", i, 5);
          fflush(stdout);
          err = fprintf(f, "Saving test  %d\n", i);
          if (err < 0) {
            pc.printf("Fail :(\n");
            error("error: %s (%d)\n", strerror(errno), -errno);
          }
        }
        */

        //pc.printf("\rSaving Test (%d/%d)... OK\n", 5, 5);
        pc.printf("\rSaving Test ... OK\n");
        /*
        pc.printf("Seeking file... ");
        fflush(stdout);
        err = fseek(f, 0, SEEK_SET);
        pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
        if (err < 0) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }*/
    }

    /////////////Prueba Mauro\\\\\\\\\\\\\\\\\\\\\\\\

    //fgetpos (f, &position);
    // Get current stream position
    //pos = ftell(f);
    //fseek(f, pos, SEEK_SET);
    err = fprintf(f, "\nInit SD\n");
    if (err < 0) {
        pc.printf("Fail :(\n");
        error("error: %s (%d)\n", strerror(errno), -errno);
    }


    ///////SI EL ARCHIVO EXISTE/////////////////////////

    // Go through and increment the numbers
    /*
    for (int i = 0; i < 5; i++) {
      pc.printf("\rIncrementing numbers (%d/%d)... ", i, 5);
      fflush(stdout);

      // Get current stream position
      long pos = ftell(f);

      // Parse out the number and increment
      int32_t number;
      fscanf(f, "%d", &number);
      number += 1;

      // Seek to beginning of number
      fseek(f, pos, SEEK_SET);

      // Store number
      fprintf(f, "inc   %ld\n", number);

      // Flush between write and read on same file
      fflush(f);
    }

    pc.printf("\rIncrementing pluv (%d/%d)... OK\n", 5, 5);
      */
    ///////////////////////////////////////////////////////////////

    /////////////////CERRAR ARCHIVO///////////////////////////////

    // Close the file which also flushes any cached writes
    pc.printf("Closing \"/fs/pluv.txt\"... ");
    fflush(stdout);
    err = fclose(f);
    pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    //////////////////////ARCHIVO CERRADO//////////////////////////////

    // Display the root directory
    pc.printf("Opening the root directory... ");
    fflush(stdout);

    DIR *d = opendir("/fs/");
    pc.printf("%s\n", (!d ? "Fail :(" : "OK"));
    if (!d) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    pc.printf("root directory:\n");
    while (true) {
        struct dirent *e = readdir(d);
        if (!e) {
            break;
        }

        printf("    %s\n", e->d_name);
    }

    pc.printf("Closing the root directory... ");
    fflush(stdout);
    err = closedir(d);
    pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    // Display the numbers file
    pc.printf("Opening \"/fs/pluv.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/pluv.txt", "r");
    pc.printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    pc.printf("numbers:\n");
    while (!feof(f)) {
        int c = fgetc(f);
        printf("%c", c);
    }

    pc.printf("\rClosing \"/fs/pluv.txt\"... ");
    fflush(stdout);
    err = fclose(f);
    pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(errno), -errno);
    }

    // Tidy up
    pc.printf("Unmounting... ");
    fflush(stdout);
    err = fileSystem.unmount();
    pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    pc.printf("Initializing the block device... ");
    fflush(stdout);

    err = blockDevice.init();
    pc.printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    pc.printf("Erasing the block device... ");
    fflush(stdout);
    err = blockDevice.erase(0, blockDevice.size());
    pc.printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    pc.printf("Deinitializing the block device... ");
    fflush(stdout);
    err = blockDevice.deinit();
    pc.printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    pc.printf("\r\n");

    pc.printf("Mbed OS filesystem example done!\n");

    pc.printf("Configurar la Hora\n");
    if (pc.readable()) {
        pc.gets(command, 8);
        for (int i=0; i<8; i++) {
            pc.printf("%x ", command[i]);
        }
        pc.printf("\n");
    }

/*

    while() {

    }
    set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
*/
    /////////////////////////////////////////////////////////////////////////////////
    /////LOOP PRINCIPAL///////
    while (true) {

        std::vector<uint8_t> tx_data;

        /////////////ESTADO -  SLEEP
        if (estado == 0) {
            pc.printf("modo sleep\n");

            //rutina modo sleep
            while (!mypin) { // Si no hay tips el micro se queda en este while
                pc.printf("sleep\n");
                ThisThread::sleep_for(5000); //Dormir por 5 segundos
            }

            estado = 3;


            ////////////ESTADO - SENSAR
        } else if (estado == 1) {

            pc.printf("modo sensor\n");
            rain = 0;

            // get some dummy data and send it to the gateway
            //analog_sensor = pot.read_u16(); // leo sensor analogico

            flipper.attach(&flip, 10.0); // 60 // Tiempo de muestreo de pluviometro
            tick_count = false;

            // Mientras tick_count=false se queda en el while contando ticks que se
            // alamacenan en rain
            pc.printf("\n Registrando lluvia"); // 0x%04X
            while (!tick_count) {
                if (mypin) {
                    //pc.printf("\nticks %d", rain); // 0x%04X
                    led1=!led1;
                    rain += 1;
                }
                wait(0.2);
            }
            estado = 2; // ir a envio de datos
            pc.printf("Estado  %d", estado);
            pc.printf("Counter: %d [0x%04X]", rain, rain);                  // 0x%04X
            pc.printf("Sensor: %d [0x%04X]", analog_sensor, analog_sensor); // 0x%04X

            ////////////ESTADO GUARDAR Y ENVIAR DATOS
        } else if (estado == 2) {

            pc.printf("Mounting the filesystem... ");
            fflush(stdout);
            /////////////////MONTO EL SISTEMA DE ARCHIVOS///////////////////////
            err = fileSystem.mount(&blockDevice);
            pc.printf("%s\n", (err ? "Fail :(" : "OK"));
            if (err) {
                // Reformat if we can't mount the filesystem
                // this should only happen on the first boot
                pc.printf("No filesystem found, formatting... ");
                fflush(stdout);
                err = fileSystem.reformat(&blockDevice);
                pc.printf("%s\n", (err ? "Fail :(" : "OK"));
                if (err) {
                    error("error: %s (%d)\n", strerror(-err), err);
                }
            }

            //////////////////Abro el archivo pluv.txt////////////////////////////

            pc.printf("Opening \"/fs/pluv.txt\"... ");
            fflush(stdout);
            f = fopen("/fs/pluv.txt", "r+");
            pc.printf("%s\n", (!f ? "Fail :(" : "OK"));
            // pc.printf("modo LoRa_TX\n");

            ///////////////////////////////////////////////////////////////////////////////
            pc.printf("Guardando datos en SD");
            fflush(stdout);
            ////////////////////////////////////////////////////////////////////////////////
            pos = ftell(f);
            err = fseek(f, pos, SEEK_END);
            pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0) {
                error("error: %s (%d)\n", strerror(errno), -errno);
            }
            err = fprintf(f, "\n;Rain:    %d", rain);
            if (err < 0) {
                pc.printf("Fail :(\n");
                error("error: %s (%d)\n", strerror(errno), -errno);
            }
            ////////////////////////////////////////////////////////////////////////////////

            /*
            pc.printf("\nSeeking file... ");
            fflush(stdout);
            err = fseek(f, 0, SEEK_SET);
            pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0) {
              error("error: %s (%d)\n", strerror(errno), -errno);
            }
            */
            pc.printf("\rSaving OK... OK\n");
            pc.printf("Closing \"/fs/pluv.txt\"... ");
            fflush(stdout);
            err = fclose(f);
            pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0) {
                error("error: %s (%d)\n", strerror(errno), -errno);
            }

            pc.printf("Unmounting... ");
            fflush(stdout);
            err = fileSystem.unmount();
            pc.printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
            if (err < 0) {
                error("error: %s (%d)\n", strerror(-err), err);
            }

            pc.printf("Initializing the block device... ");
            fflush(stdout);

            err = blockDevice.init();
            pc.printf("%s\n", (err ? "Fail :(" : "OK"));
            if (err) {
                error("error: %s (%d)\n", strerror(-err), err);
            }

            pc.printf("Erasing the block device... ");
            fflush(stdout);
            err = blockDevice.erase(0, blockDevice.size());
            pc.printf("%s\n", (err ? "Fail :(" : "OK"));
            if (err) {
                error("error: %s (%d)\n", strerror(-err), err);
            }

            pc.printf("Deinitializing the block device... ");
            fflush(stdout);
            err = blockDevice.deinit();
            pc.printf("%s\n", (err ? "Fail :(" : "OK"));
            if (err) {
                error("error: %s (%d)\n", strerror(-err), err);
            }

            pc.printf("\r\n");

            pc.printf("Mbed OS filesystem example done!\n");

            // Acomodo la trama
            // tx_data.push_back((analog_sensor >> 8) & 0xFF);
            // tx_data.push_back(analog_sensor & 0xFF);
            // tx_data.push_back((rain >> 8) & 0xFF);
            // tx_data.push_back(rain & 0xFF);

            // Envio Data
            // send_data(tx_data);

            estado = 3;
            pc.printf("Estado  %d", estado);

        } else if (estado == 3) {

            flipper.attach(&timer60seg, 10.0); // 60 // setup flipper to call timer60seg after 60 seconds
            pc.printf("\nVerifiacando si esta lloviendo");
            while (!timer60s) {
                if (mypin) {
                    pc.printf("..."); // 0x%04X
                    rain += 1;
                }
                if (rain > 2) {
                    estado = 1;
                    break;
                }
                wait(0.2);
            }
            if (timer60s && rain == 0) {
                estado = 0; // Ir a modo Sleep
            } else {
                estado = estado;
            }

            timer60s = false;
        }
    }

    return 0;
}
