#include "mbed.h"
#include "VL53L0X.h"

#define range1_addr (0x56)
#define range2_addr (0x60)
#define range1_XSHUT   p8  //D7
#define range2_XSHUT   p9   //D8
#define VL53L0_I2C_SDA   p28  //D14 
#define VL53L0_I2C_SCL   p27  //D15  
 
Serial pc(USBTX, USBRX);
Timer       t;
static DevI2C devI2c(VL53L0_I2C_SDA,VL53L0_I2C_SCL); 
 
int main()
{   
    /*Contruct the sensors*/ 
    static DigitalOut shutdown1_pin(range1_XSHUT);
    static VL53L0X range1(&devI2c, &shutdown1_pin, NC);
    static DigitalOut shutdown2_pin(range2_XSHUT);
    static VL53L0X range2(&devI2c, &shutdown2_pin, NC);
    /*Initial all sensors*/   
    range1.init_sensor(range1_addr);
    range2.init_sensor(range2_addr);

    /*Get datas*/
    uint32_t distance1;
    uint32_t distance2;
    int status1;
    int status2;
    uint32_t tm_all_work;
    
    while(1){
        t.reset();
        t.start();
        status1 = range1.get_distance(&distance1);
        if (status1 == VL53L0X_ERROR_NONE) {
            printf("Range1 [mm]:         %6ld  ", distance1);
        } else {
            printf("Range1 [mm]:             --  ");
        }

        status2 = range2.get_distance(&distance2);
        if (status2 == VL53L0X_ERROR_NONE) {
            printf("Range2 [mm]:         %6ld\r\n", distance2);
        } else {
            printf("Range2 [mm]:             --\r\n");
        }
        tm_all_work = t.read_ms();
        if (tm_all_work < 99){
            wait_ms(100 - tm_all_work);
        }
        pc.printf("   %d  \r\n", tm_all_work);
    }
 
}
 
