#include "mbed.h"

DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut signal1(p8);
DigitalOut signal2(p10);
Serial pc(USBTX, USBRX); // tx, rx

//Function stubs

void setBulbValue(int bulbNum, int red, int green, int blue);
void updateString(void);
void setPixel(int xCoord, int yCoord, int red, int green, int blue);

//constants

const int bitsPerBulb = 26;
const int numberOfBulbs = 56;
int ten = 10; // Ten microseconds
int twenty = 20; // Twenty microseconds
int coordTable[55] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 , 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33 , 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54};
int bulbBitStream[bitsPerBulb * numberOfBulbs];

// Code


int main() {

    //enumerate String 1 of bulb bitstream array.
    for (int bulb = 0 ; bulb < numberOfBulbs ; bulb++) {
        setBulbValue(bulb, 0, 0, 0); // all WHITE
    }
    updateString();

    while (true) {
        for (int y = 0 ; y < 5 ; y++) {
            for  (int x = 0 ; x < 11 ; x++) {
                setPixel (x, y, 13, 0, 0);
                updateString();
                setPixel (x, y, 0, 0, 13);
                updateString();
            }
        }
    }
}


void setPixel(int xCoord, int yCoord, int red, int green, int blue) {
    setBulbValue(coordTable[(yCoord * 11) + xCoord], red, green, blue);
}


void setBulbValue(int bulbNum, int red, int green, int blue) {

    int intensity = 204;

    int bulbBitstreamStart = (bulbNum * bitsPerBulb); // So this seems right.

    // Bulb number
    //pc.printf("Bulb %d ", bulbNum);
    for (int loop = 5 ; loop >= 0 ; loop--) {

        if ((bulbNum % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            // pc.printf("0");
        }
        bulbNum = bulbNum / 2;
    }
    // Intensity
    //pc.printf(" Intensity %d ", intensity);
    for (int loop = 13 ; loop >= 6 ; loop--) {

        if ((intensity % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        intensity = intensity / 2;
    }
    // Blue
    //pc.printf(" Blue %d ", blue);
    for (int loop = 17 ; loop >= 14 ; loop--) {

        if ((blue % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        blue = blue / 2;

    }
    // Green
    //pc.printf(" Green %d ", green);
    for (int loop = 21 ; loop >= 18 ; loop--) {

        if ((green % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        green = green / 2;
    }
    // Red
    //pc.printf(" Red %d ", red);
    for (int loop = 25 ; loop >= 22 ; loop--) {

        if ((red % 2) > 0) {
            bulbBitStream[bulbBitstreamStart + loop] = 1;
            //pc.printf("1");
        } else {
            bulbBitStream[bulbBitstreamStart + loop] = 0;
            //pc.printf("0");
        }
        red = red / 2;
    }
}

void updateString(void) {
    // set bus state low for 60 microseconds to make sure we're reset.
    signal1 = 0;
    wait_us(twenty * 3);

    for (int x = 0; x < numberOfBulbs ; x++) //Iterate for as many bulbs are in the string
    {// x
        //Start Bit: High for 10microSeconds
        signal1 = 1;
        wait_us(ten);
        signal1 = 0;

        for (int i = 0; i < bitsPerBulb; i++) { // i
            if (bulbBitStream[i + (x * bitsPerBulb)] == 0) {
                signal1 = 0;
                wait_us(ten);
                signal1 = 1;
                wait_us(twenty);
                signal1 = 0;
            } else {
                signal1 = 0;
                wait_us(twenty);
                signal1 = 1;
                wait_us(ten);
                signal1 = 0;
            }
        } // i
        wait_us(twenty*2); // Wait AT LEAST 30 microseconds to end frame, so 40 in this case.
    }// x


} // end updateString ()







