/*Matthew Sims
  Integrated RC and DC
  Moves 2 servos like windshield wipers and makes a dc motor seed up and switch direction atfer each cycle
  10/13/15
*/

#include "mbed.h"      //Import Libraries
#include "Motor.h"
#include "Servo.h"

Motor m(p25,p27,p28);   //Initialize motor and servos
Servo s1(p21);
Servo s2(p22);

int main()
{
    float speed=.2; //Sets initial speed to .2
    m.speed(speed);
    s1.calibrate(.0009,90); //Calibrate the servos
    s2.calibrate(.0009,90);

    while(1) {

        //Set of loops moves the servos from 0 to 1.0, then it moves them the opposite way
        for(float pos=0.0; pos<=1.0; pos+=.01) {
            s1=pos;
            s2=1-pos;   //s2 is opposite position of s1
            wait(.05);
        }
        
        m.speed(speed*-1);      //Changes direction of dc motor
        
        for(float pos=1.0; pos>=0.0; pos-=.01) {
            s1=pos;
            s2=1-pos;
            wait(.05);
        }
                                    //Changes direction
        if(speed<1.0)    //Speeds up DC by .1 if it isn'tt at full speed
            speed+=.1;
        m.speed(speed); //sets the speed of dc motor
    }
}
