/*! Lab2
 *  Used to turn the FRDM-KL46Z into a voltmeter.
 *  Modified from: https://developer.mbed.org/users/star297/code/FRDM-KL46Z-LCD-rtc-Demo/
 * \author  Matthew Shuman
 *
 * \date    August 28th, 2016

 * \bug     No bugs yet

 * @code
 * #include "mbed.h"
 * #include "SLCD.h"

 * SLCD myLcd;
 * int myNumber=0;
 * int main()
 * {
 *     while(1) {
 *        myLcd.printf("00%2.0i",myNumber);
 *        ++myNumber;
 *         wait(.1);
 *     }//end of while
 * }//end of main
 * @endcode
 */


#include "mbed.h"
#include "SLCD.h"

SLCD slcd;                          //Setup the LCD on the FRDM-KL46Z.
DigitalOut  led1(LED1);             //Setup the green LED.
AnalogIn    ReadVoltage(A0);        //Setup the analog input.
BusOut display(PTE31, PTE19, PTE18, PTE17, PTE16, PTE6, PTE3, PTE2);
//This creates an array of ports with PTE2 is the MSB and PTE31 is the LSB.

main()
{
   
            //Add a pull up resistor to SW1.
    led1 = 0;                       //Turn on the green LED.
    slcd.DP1(1);                    //Turn on the decimal point

    while(1) {
        led1=!led1;                     //Toggle the green LED
        for(int i=0; i<16 ; i++){
            slcd.printf("   %i",i);  //Use this line to read the analog input.
            switch(i){
                case 0: display = 0x01;break; //also 0x01 //.abcedfg
                case 1: display = 0xCF;break;
                case 2: display = 0x92;break;
                case 3: display = 0x4F;break;
                case 4: display = 0x66;break;
                case 5: display = 0xA8;break;
                case 6: display = 0x40;break;
                case 7: display = 0x0F;break;
                case 8: display = 0x80;break;
                case 9: display = 0x77;break;
            }//end of switch
            wait(2);
        }//end of for
    }//end of while
}//end of main
