#include "mbed.h"
#include "Blinker.h"

//This creates Pulse Width Modulated outputs, r and g, and connects them to the red and green LED.
PwmOut r(LED_RED);
PwmOut g(LED_GREEN);

int main()
{
// setup instance of new Blinker class, myBlinker
    Blinker myBlinker;
    while(1) {
        for(float i = 0; i < 5; i++) {
            // blinks the green LED at 2 Hz, with 75% brightness
            myBlinker.blink(g, 2, .75);
        }
        for(float i = 0; i < 10; i++) {
            // blinks the red LED at 4 Hz, with 15% brightness
            myBlinker.blink(r, 4, .15);
        }

    }
}

