/*! Lab2
 *  Used to turn the FRDM-KL46Z into a voltmeter.
 *  Modified from: https://developer.mbed.org/users/star297/code/FRDM-KL46Z-LCD-rtc-Demo/
 * \author  Matthew Shuman
 *
 * \date    August 28th, 2016

 * \bug     No bugs yet

 * @code
 * #include "mbed.h"
 * #include "SLCD.h"

 * SLCD myLcd;
 * int myNumber=0;
 * int main()
 * {
 *     while(1) {
 *        myLcd.printf("00%2.0i",myNumber);
 *        ++myNumber;
 *         wait(.1);
 *     }//end of while
 * }//end of main
 * @endcode
 */


#include "mbed.h"
#include "SLCD.h"

SLCD slcd;                          //Setup the LCD on the FRDM-KL46Z.
DigitalOut  led1(LED1);             //Setup the green LED.
AnalogIn    ReadVoltage(A0);        //Setup the analog input.
DigitalOut  SpeakerOut(PTE30);
//AnalogOut   SpeakerOut(PTE30); 

main()
{
   
            //Add a pull up resistor to SW1.
    led1 = 0;                       //Turn on the green LED.
    slcd.DP1(1);                    //Turn on the decimal point
    SpeakerOut = 0;
    
    while(1) {
        led1=!led1;                     //Toggle the green LED
        slcd.printf("%4.0f", ReadVoltage.read()*3300.f);  //Use this line to read the analog input.
        wait_ms(ReadVoltage.read()*10);                  //Wait some time
        SpeakerOut =! SpeakerOut;
        
//        SpeakerOut = 0;
//        wait_ms(1);
//        SpeakerOut = .25;
//        wait_ms(1);
//        SpeakerOut = .50;
//        wait_ms(1);
//        SpeakerOut = .75;
//        wait_ms(1);
//        SpeakerOut = 1;
//        wait_ms(1);

    }
}
