// ES305 Lab #6

//program to drive the DC motor with a user specified duty cycle

// include libraries and define PI
#include "mbed.h"
#include "mbedWSEsbc.h"
#define PI (3.14159)

Ticker Controller;

//declare variables for data handling
float TotalTime; //establishing float called Totalime
float UserDutyCycle; //establishing float called UserDutyCycle
float Time; //establishing float called Time
float DataStream = 0.01; //establishing float called DataStream
float Ts = .0083; //establishing float called Ts
float speed;  //establishing float called speed
float enc1, ang, angp, dc, dspd, spderr, kp; //encoder, angle, previous angle, duty cycle

//declare function definitions
void ctrCode(); //function attaches to ticker
void pCtrlCode();

int main ()

{
    mbedWSEsbcInit(115200);
    mot_en1.period(0.020);

    while(1)    {
        pc.scanf("%f,%f,%f", &TotalTime,&dspd, &kp);

//Set current time to zero
        Time = 0.0;
        t.reset();

        //attach ctrCode function ticker to the obj with specified period

        Controller.attach(&pCtrlCode,Ts);
        t.start(); //start timer object

//loop that interates only if current time <+ desired run time; Data streaming loop

        while(Time <= TotalTime) {
            Time = t.read();
            pc.printf("%f,%f,%f\n" , Time, speed, dc);
            wait(DataStream); //print data at 100Hz
        }

        Controller.detach();
        mot_control(1,0.0); //motor shuts off when experiment complete
    } //end while 1

} //end main

void ctrCode()
{

// read encoder
    enc1 = LS7366_read_counter(1);

//convert from counts to radians
    ang = 2*PI*enc1/6500;

//estimated speed
    speed = (ang-angp)/Ts;

//age variables
    angp = ang;

//compute the duty cycle for motor
    dc = UserDutyCycle;

//send duty cycle to motor
    mot_control(1,dc);

} //end ctrCode()

void pCtrlCode() // function to attach to ticker
{

    // Read encoder
    enc1 = LS7366_read_counter(1); // input is the encoder channel

    // Convert from counts to radians
    ang = 2.0*PI*enc1/6400.0;

    // Estimate speed
    speed = (ang-angp)/Ts;

    // Age variables
    angp = ang;

    // compute error
    spderr = dspd-speed;

    // compute duty cycle for motor
    if(Time<0.1) {
        dc = 0.0;
    } else {
        dc = kp*(spderr)/20;
    }
    // enforce duty cycle saturation
    if(dc>1.0) {
        dc = 1.0;
    } else if(dc<-1.0) {
        dc = -1.0;
    }
    // motor control
    mot_control(1,dc); // first input is the motor channel, second is duty cycle
} //end pctrl function