// This header file is for the core firmware functions
// associated with the mbed daughter board.

/////////////////////////////////////////////////////////
// "boot_msg" : Function to send a bootup message via the
// usb serial link.
void boot_msg(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "scan_1s" : Function to check the recieve buffer
// periodically (1s) to make sure there are no dormant
// commands left in there.
void scan_1s(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "command_clean" : Function to clean a command from the
// recieve buffer quickly.
void command_clean(uint8_t t_pnt, uint8_t c_pnt);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "diag_reply" : Function to send diagnostics info back
// to the host PC via the USB serial.
void diag_reply(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "dshift_out" : Function to shift data out via the
// shift register.
// This will effect the digital shift outputs and the
// multiplexer configuration.
void dshift_out(uint16_t sdata_out);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "freq_reply" : Function send a reply message back to
// the host PC to say which frequency was detected on
// the directsync pin. This will have been applied to the
// motordrive also.
void freq_reply(int freq, uint8_t command);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "volts_IR" : Function reads the analogue input voltage
// present on the directsync_in pin
void volts_IR(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "ultra_range" : Function performs an ultrasonic range
// measurement and outputs the duration of the sensor
// output pulse.
void ultra_range(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "directsync" : Function read the input frequency on
// the direct sync pin. This frequency should then be
// applied to the motor drive. This routine will then
// return the frequency it applied.
int directsync(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "get_disc_freq" : Function read the frequency of the
// spinning disc. This routine will then
// return the frequency measured.
int get_disc_freq(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "set_servo" : Function sets the servo speed as a
// floating point fraction of 100%.
void set_servo(uint8_t servo, float speedval);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "rotate_scene_cont" : Function to turn ranging scene
// to the left or the right by a small amount
void rotate_scene_cont(uint8_t direction);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "rotate_scene" : Function to turn ranging scene
// to the left or the right by a small amount
void rotate_scene(uint8_t direction);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "set_discfreq" : Function attempts to set the disc
// rpm to the defined value. When rpm is reached it stops
// trying.
void set_discfreq(int discrpm);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "dshift_combine" : Function to combine all shift reg
// elements into a single 16bit variable, for shifting.
// This will return the 16bit variable.
uint16_t dshift_combine(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "set_mux_chan" : Function to configure one of the five
// daughter board multiplexers. (0 to 4). Each multiplexer
// can select channels 1,2,3 or high-impedance (0).
// This will effect the multiplexer configuration.
void set_mux_chan(uint8_t mux, uint8_t chan);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "print_array" : Function to send all character bytes
// from an array out through the serial port.
void print_array(char *array, uint8_t size);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "stan_reply" : Function to send a standard reply from
// the mBed to the Host PC. A standard reply is one that
// confirms that the message sent by the host has been
// actioned.
void stan_reply(char command);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "fdigi_out" : Function to assert digital outputs
// attached directly to the mbed pins p29 and p30.
void fdigi_out(uint8_t pin, bool pinval);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "sdigi_out" : Function to assert digital outputs
// attached to the daughter board shift register.
// digi channels a, b, c, d, e and f.
// This will effect the digital shift outputs only.
void sdigi_out(char digi_ch, bool pinval);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "check_usb_rec_flg" : Function to see if any bytes
// have come in, on the USB serial. Returns the
// usb_receive_flg.
bool check_usb_rec_flg(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "clr_usb_rec_flg" : Function to clear the 
// usb_receive_flg.
void clr_usb_rec_flg(void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "usb_serial_r" : Function to deal with serial bytes
// being received via USB serial. When a byte is rec'd
// it is copied to a circular buffer and then a rec'd
// flag is asserted to show that action is needed.
void usb_serial_r (void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "usb_serial_t" : Function to send array of characters
// to the host PC via the usb serial. Returns the number
// of characters written to the USB serial.
uint8_t usb_serial_t (char txstring[]);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "c_lookchk" : Function to check to see if the command
// byte exists in any of the lookup tables. If it does
// then true is returned.
bool c_lookchk (uint8_t command);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "c_looklen" : Function to lookup the defined length of
// the given command's data bytes. Returns the number of
// data bytes that should exist.
uint8_t c_looklen (uint8_t command);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "check_msg" : That generates the final check byte from
// the message found between tmp_pnt and chk_pnt. If the
// check byte matches then true is returned.
bool check_msg(uint8_t tmp_pnt, uint8_t chk_pnt);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "usb_serial_bufscan" : Function to check the INPUT
// BUFFER to see if a valid command has been received. If
// so then the function returns with the command ID.
uint8_t usb_serial_bufscan (void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "usb_serial_setup" : Function to set up the USB serial
// interface.
void usb_serial_setup (void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "dio_setup" : Function to set up the standard digi IO
void dio_setup (void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "servo_setup" : Function to set up the standard servos
void servo_setup (void);
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
// "startup_config" : Function to set up all the defaults
// for the system.
void startup_config (void);
/////////////////////////////////////////////////////////