// This file firstly defines a lookup table of all the valid
// command IDs and the number of data bytes that each should have.
// Below the lookup table is a memory used to store those data
// bytes when a valid command is received.
#include "stdint.h"

/////////////////////LOOKUP TABLE////////////////////////////////////////
extern const uint8_t c_matrix[26]= {
    'f' , 3 ,       // ID = "f"(0x66) , 3 data bytes
    's' , 2 ,       // ID = "s"(0x73) , 2 data bytes
    'i' , 0 ,       // ID = "i"(0x69) , 0 data bytes
    'y' , 0 ,       // ID = "y"(0x79) , 0 data bytes
    'p' , 0 ,       // ID = "p"(0x70) , 0 data bytes
    'm' , 2 ,       // ID = "m"(0x6D) , 2 data bytes
    'd' , 0 ,       // ID = "d"(0x64) , 0 data bytes
    'r' , 3 ,       // ID = "r"(0x72) , 3 data bytes
    'q' , 3 ,       // ID = "q"(0x71) , 3 data bytes
    't' , 0 ,       // ID = "t"(0x74) , 0 data bytes
    'v' , 0 ,       // ID = "v"(0x76) , 0 data bytes
    'o' , 1 ,       // ID = "o"(0x6F) , 1 data bytes
    'u' , 0 ,       // ID = "u"(0x75) , 0 data bytes
    };
/////////////////////////////////////////////////////////////////////////

///////////////////DATA BYTE STORAGE/////////////////////////////////////
extern uint8_t c_data_0x66[3]= { 0, 0, 0, };   //data holder for "f" 0x66
extern uint8_t c_data_0x73[2]= { 0, 0, };      //data holder for "s" 0x73
                                 //do not need a data holder for "i" 0x69
                                 //do not need a data holder for "y" 0x79
                                 //do not need a data holder for "p" 0x70
extern uint8_t c_data_0x6D[2]= { 0, 0, };      //data holder for "m" 0x6D
                                 //do not need a data holder for "d" 0x64
extern uint8_t c_data_0x72[3]= { 0, 0, 0, };   //data holder for "r" 0x72
extern uint8_t c_data_0x71[3]= { 0, 0, 0, };   //data holder for "q" 0x71
                                 //do not need a data holder for "t" 0x74
                                 //do not need a data holder for "v" 0x76
extern uint8_t c_data_0x6F[1]= { 0, };         //data holder for "o" 0x6F
                                 //do not need a data holder for "u" 0x75
/////////////////////////////////////////////////////////////////////////