#include "mbed.h"
#include "lcd.h"

//register select, read/write, enable, (db4,db5,db6,db7)
lcd display(p21, p22, p23, p24, p25, p26, p27);

int main() {
    display.printf("Hello World\n");
    display.printf("Number: %d", 15); 
    
    wait(3);
       
    display.clear();
    
    //these graphics were generated using http://www.quinapalus.com/hd44780udg.html               
    int graphics[8][8] = {{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f},
                          {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f},
                          {0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f},
                          {0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f},
                          {0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f},
                          {0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f},
                          {0x00, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f},
                          {0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f}};
                          
    //define each character, user defined characters are of the values 0 through 7
    for(int i = 0; i < 8; i++) {
        display.defineCharacter(i, graphics[i]);
    }
    
    int glyphs[9] = {0x20, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07};
    
    int start = 0;
    while(1) {
        for(int i = 0; i < 16; i++) {
            int magnitude = (i + start);
            if(magnitude > 16) {
                magnitude = 32 - magnitude;
            }
            if(magnitude < 0) {
                magnitude = magnitude * -1;
            }
            display.locateCharacter(0, i, magnitude < 9 ? glyphs[0] : glyphs[magnitude - 8]);
            display.locateCharacter(1, i, magnitude > 8 ? glyphs[8] : glyphs[magnitude]);
        }
        start = (start + 1) % 33;
        wait(.03);
    }
}