#ifndef LCD
#define LCD

#include "mbed.h"

#define klcdWriteMode           0
#define klcdReadMode            1
#define klcdInstructionRegister 0
#define klcdDataRegister        1
#define klcdEnableHigh          1
#define klcdEnableLow           0

class lcd : public Stream{
    public:
        //uses the four bit interface with a read/write pin in order to read the busy flag
        lcd(PinName _rs, PinName _rw, PinName _e, PinName _db4, PinName _db5, PinName _db6, PinName _db7);
        
        //clear the screen
        void clear();
        
        //move to a location on the screen, the next printf or putc call
        //  will locate the character at the location
        void locate(int _row, int _column);
        
        //place a character at a location
        void locateCharacter(int _row, int _column, int _char);
        
        //define a character with a 8 element array of 5 bit wide pixel
        //  definitions, from top to bottom
        void defineCharacter(int _char, int _charData[8]);
        
    protected:
        void setMode(int _mode);
        void waitUntilNotBusy();
        int readByte(int _reg);
        void writeByte(int _reg, int _byte, bool _wait = true);
        int readNibble(int _reg);
        void writeNibble(int _reg, int _nibble);
        
        //stream implementation
        virtual int _putc(int _value);
        virtual int _getc();
        
        BusInOut dataBus;
        DigitalOut registerSelect;
        DigitalOut readWrite;
        DigitalOut enable;
               
        int currentMode;
        int column;
        int row;
};

#endif