// Mbed 1 Robot, robot base sensors and bluetooth
// serial port pins 9 and 10(tx rx) used to communicate with robot base
#include "mbed.h"
#include "m3pi.h"
#include "string"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
//Serial pc(USBTX, USBRX); // for terminal diagnostics
Serial device(p28, p27); // Bluetooth comms tx rx 
Serial communicate(p13, p14); // to Mbed 2 tx rx
m3pi m3pi;
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalIn stopgo (p20); // from mbed2 sensor move forward or not something blocking (1=block)

char letters[26] = {
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
    'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
    'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
};
char receivedchar[10];


void rxCallback() //interrupt from rx serial port
{
    myled3=!myled3;
    receivedchar[0]=communicate.getc(); // put received character from mbed2 into array for later
 // pc.printf("%d ",receivedchar[0]);
    //m3pi.cls();
    m3pi.locate(0,0); // x then y co-ordinates on screen
    m3pi.printf("%d  ",receivedchar[0]);
    //wait (0.2);
}

void txCallback() //interrupt from tx serial port
{
    myled4=!myled4;
}

int main()
{
    int  cmd_option;
    char cmd_convert;
    // Display welcome message to the scripting
   // display_part("Init : ", "FIDO-Ed");

    // Configure device baud rates
    device.baud(115200); //Bluetooth
 //   pc.baud(115200); //for diagnostics pc
    communicate.baud(19200); //to mbed 2
    setbuf(stdin,NULL); //clear serial input buffer
    communicate.attach(&txCallback, Serial::TxIrq);
    communicate.attach(&rxCallback, Serial::RxIrq); //for serial interrupt callback function
    m3pi.cls(); 
    cmd_convert=0;
    
    // Global program variables
   bool nerror  = true;

    // Iterate while simulation is error free
    while(nerror) 
    {
         myled1=stopgo; // mbed2 says stop or go - 1/on =something blocking movement  
        // Check for readability of device
        if(device.readable()) 
           {
            // Display device recieved transactions
            // Fetch command and cast to char value
            cmd_option  = device.getc();
            cmd_convert = static_cast<char>(cmd_option);
             m3pi.locate(0,1);
             m3pi.printf("B%c %d", cmd_convert,cmd_option);
            // Hold for half a second
            wait(0.2);
            }

if (cmd_convert !=0)
    {
     if(cmd_convert >=49 && cmd_convert <=53) // numbers 1 to 5 from mobile app, Movement
       {  
     // Determine action to be taken based on switching
        switch(cmd_convert) 
            {
         
             case '1': //Move Forward
                       if(!stopgo) //if nothing blocking way
                          {
                        //  while (!stopgo)
                        //     {
                             communicate.putc(49); //move forward - send 1 to mbed 2
                             cmd_convert=0;
                             m3pi.forward(0.25);
                             wait(1.1);
                             m3pi.stop();
                          //   }
                          }
                         else 
                          {    
                          communicate.putc(53); // dont move forward and send 5 to mbed 2
                          }    
                        m3pi.stop();
                        break;

                case '2': //Turn Right
                       if(!stopgo) //if nothing blocking way
                          {
                         // while (!stopgo)
                         //       {
                                  communicate.putc(50);// turn right and send 2 to mbed2 
                                  cmd_convert=0;
                                  m3pi.right(0.25);
                                  wait(0.5);
                                  m3pi.stop();
                         //         }
                         }
                      else 
                         {
                         m3pi.stop();    
                         communicate.putc(53); // dont move forward and send 5 to mbed 2
                         }                  
                     break;

                case '3': //Backwards - no movement
                         communicate.putc(51); // turn around and send 3 to mbed 2
                         cmd_convert=0;
          //             m3pi.right(0.5);
          //             wait(0.25);
          //             m3pi.stop();
                    break;

                  case '4': // Turn Left
                      if(!stopgo) //if nothing blocking way
                        {
                          // while (!stopgo)
                          //       {
                                 communicate.putc(52); //turn left and send 4 to mbed2
                                 cmd_convert=0;
                                 m3pi.left(0.25);
                                 wait(0.5);
                                   m3pi.stop();
                          //       }
                        }
                      else 
                         {
                         m3pi.stop();    
                         communicate.putc(53); // dont move forward and send 5 to mbed 2
                         }  
                      break;
                                            
      
        } // switch    
        }
        if(cmd_convert >=65 && cmd_convert <=122) // send any other valid command to mbed2
          {
            communicate.putc(cmd_convert); //send cmd_convert to mbed 2
            cmd_convert=0;
          }  //cmd_convert >=65
    } // if cmd_convert not 0
}}