//---------------1-------------------------

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);

Serial pc(USBTX, USBRX); // tx, rx


//-----------------2------------------------
//Addresses
#define REVID 0x00    //ASIC Revision Number
#define OPSTATUS 0x04   //Operation Status
#define STATUS 0x07     //ASIC Status
#define START 0x0A      //Constant Readings
#define PRESSURE 0x1F   //Pressure 3 MSB
#define PRESSURE_LSB 0x20 //Pressure 16 LSB
#define TEMP 0x21       //16 bit temp

//---------------3-----------------------
    
float temp_in;
unsigned long pressure_lsb;
unsigned long pressure_msb;
unsigned long temp_pressure;
unsigned long pressure;

char read_register(char register_name)
{
    register_name <<=2;
    register_name &= 0xFC;
    cs=0; //Select SPI device
    spi.write(register_name); //Send register location
    char register_value=spi.write(0x00);
    cs=1;
    return register_value;  
}


void write_register(char register_name, char register_value)
{
    register_name <<= 2;
    register_name |= 0x02; //le estamos diciendo que escriba
    cs=0; //Select SPI device
    spi.write(register_name); //Send register location
    spi.write(register_value); //Send value to record into register
    cs=1;
} 

float read_register16(char register_name)
{   
    register_name <<= 2;
    register_name &= 0xFC; //Read command
    cs=0; //Select SPI Device
    spi.write(register_name); //Write byte to device
    int in_byte1 = spi.write(0x00);    
    int in_byte2 = spi.write(0x00);
    cs=1;
    float in_word= (in_byte1<<=8) | (in_byte2);   
    return(in_word);
}


//-----------------4------------------------

int main() {
// configuracion---------------------------------
    cs=1;
    spi.frequency(500000); // the fastest of the sensor
    spi.format(8, 0); // duda son dos palabras de 8 bits? 
    wait(0.5);
//------------------------------------------------
// pc.printf("RESET\r\n");
write_register(0x06,0x01);
wait(0.5);

// pc.printf("Initialize High Resolution Constant Reading Mode\r\n");
write_register(0x03,0x0A);
wait(0.5);

while (1) {  
  pressure_msb = read_register(PRESSURE);
  pressure_msb &= 0x07;
  pressure_lsb = read_register16(PRESSURE_LSB);
  pressure = ((pressure_msb<<16)| pressure_lsb);
  pressure /= 4;
  temp_in = read_register16(TEMP);
  lcd.cls();
  if (temp_in > 0x3FFF) {
        temp_in = 0x3FFF - temp_in;
        lcd.locate(0, 0);
        lcd.printf("t:%.2f",temp_in);
        temp_in = temp_in / 20;
        lcd.locate(0, 1);
        lcd.printf("Temp :-");
        lcd.printf("%.1f",temp_in);
  // pc.printf("TEMPERATURA: %.2f,PRESION:  %.2u\r",temp_in ,pressure);
  } else {
        lcd.locate(0, 0);
        lcd.printf("t:%.2f",temp_in);
        lcd.locate(0, 1);
        temp_in = temp_in / 20;
        lcd.printf("Temp :+");
        lcd.printf("%.1f",temp_in);
  // pc.printf("TEMPERATURA: %.2f,PRESION:  %.2u\r",temp_in ,pressure);
  }
  // temp_in = temp_in / 20;
  wait(5);
}

}
