#include "mbed.h"
#include "PAJ7620U2.h"

bool PAJ7620U2::RegisterWrite(uint8_t address, uint8_t value)
{
	uint8_t sendData[2];
	sendData[0] = address;
	sendData[1] = value;
	if (_I2c->write(_SlaveAddress, (const char*)sendData, sizeof(sendData), false) != 0) return false;

	return true;
}

bool PAJ7620U2::RegisterWrite(uint8_t address, const uint8_t* data, int dataSize)
{
	uint8_t* sendData = (uint8_t*)alloca(1 + dataSize);
	sendData[0] = address;
	memcpy(&sendData[1], data, dataSize);
	if (_I2c->write(_SlaveAddress, (const char*)sendData, 1 + dataSize, false) != 0) return false;

	return true;
}

bool PAJ7620U2::RegisterRead(uint8_t address, uint8_t* value)
{
	uint8_t sendData[1];
	sendData[0] = address;
	if (_I2c->write(_SlaveAddress, (const char*)sendData, sizeof(sendData), true) != 0) return false;

	uint8_t recvData[1];
	if (_I2c->read(_SlaveAddress, (char*)recvData, sizeof(recvData)) != 0) return false;
	*value = recvData[0];

	return true;
}

bool PAJ7620U2::RegisterRead(uint8_t address, uint8_t* data, int dataSize)
{
	uint8_t sendData[1];
	sendData[0] = address;
	if (_I2c->write(_SlaveAddress, (const char*)sendData, sizeof(sendData), true) != 0) return false;

	if (_I2c->read(_SlaveAddress, (char*)data, dataSize) != 0) return false;

	return true;
}

const PAJ7620U2::RegisterAddressValue PAJ7620U2::_InitRegisterArray[] = {
	{ 0xEF, 0x00, },
	{ 0x32, 0x29, },
	{ 0x33, 0x01, },
	{ 0x34, 0x00, },
	{ 0x35, 0x01, },
	{ 0x36, 0x00, },
	{ 0x37, 0x07, },
	{ 0x38, 0x17, },
	{ 0x39, 0x06, },
	{ 0x3A, 0x12, },
	{ 0x3F, 0x00, },
	{ 0x40, 0x02, },
	{ 0x41, 0xFF, },
	{ 0x42, 0x01, },
	{ 0x46, 0x2D, },
	{ 0x47, 0x0F, },
	{ 0x48, 0x3C, },
	{ 0x49, 0x00, },
	{ 0x4A, 0x1E, },
	{ 0x4B, 0x00, },
	{ 0x4C, 0x20, },
	{ 0x4D, 0x00, },
	{ 0x4E, 0x1A, },
	{ 0x4F, 0x14, },
	{ 0x50, 0x00, },
	{ 0x51, 0x10, },
	{ 0x52, 0x00, },
	{ 0x5C, 0x02, },
	{ 0x5D, 0x00, },
	{ 0x5E, 0x10, },
	{ 0x5F, 0x3F, },
	{ 0x60, 0x27, },
	{ 0x61, 0x28, },
	{ 0x62, 0x00, },
	{ 0x63, 0x03, },
	{ 0x64, 0xF7, },
	{ 0x65, 0x03, },
	{ 0x66, 0xD9, },
	{ 0x67, 0x03, },
	{ 0x68, 0x01, },
	{ 0x69, 0xC8, },
	{ 0x6A, 0x40, },
	{ 0x6D, 0x04, },
	{ 0x6E, 0x00, },
	{ 0x6F, 0x00, },
	{ 0x70, 0x80, },
	{ 0x71, 0x00, },
	{ 0x72, 0x00, },
	{ 0x73, 0x00, },
	{ 0x74, 0xF0, },
	{ 0x75, 0x00, },
	{ 0x80, 0x42, },
	{ 0x81, 0x44, },
	{ 0x82, 0x04, },
	{ 0x83, 0x20, },
	{ 0x84, 0x20, },
	{ 0x85, 0x00, },
	{ 0x86, 0x10, },
	{ 0x87, 0x00, },
	{ 0x88, 0x05, },
	{ 0x89, 0x18, },
	{ 0x8A, 0x10, },
	{ 0x8B, 0x01, },
	{ 0x8C, 0x37, },
	{ 0x8D, 0x00, },
	{ 0x8E, 0xF0, },
	{ 0x8F, 0x81, },
	{ 0x90, 0x06, },
	{ 0x91, 0x06, },
	{ 0x92, 0x1E, },
	{ 0x93, 0x0D, },
	{ 0x94, 0x0A, },
	{ 0x95, 0x0A, },
	{ 0x96, 0x0C, },
	{ 0x97, 0x05, },
	{ 0x98, 0x0A, },
	{ 0x99, 0x41, },
	{ 0x9A, 0x14, },
	{ 0x9B, 0x0A, },
	{ 0x9C, 0x3F, },
	{ 0x9D, 0x33, },
	{ 0x9E, 0xAE, },
	{ 0x9F, 0xF9, },
	{ 0xA0, 0x48, },
	{ 0xA1, 0x13, },
	{ 0xA2, 0x10, },
	{ 0xA3, 0x08, },
	{ 0xA4, 0x30, },
	{ 0xA5, 0x19, },
	{ 0xA6, 0x10, },
	{ 0xA7, 0x08, },
	{ 0xA8, 0x24, },
	{ 0xA9, 0x04, },
	{ 0xAA, 0x1E, },
	{ 0xAB, 0x1E, },
	{ 0xCC, 0x19, },
	{ 0xCD, 0x0B, },
	{ 0xCE, 0x13, },
	{ 0xCF, 0x64, },
	{ 0xD0, 0x21, },
	{ 0xD1, 0x0F, },
	{ 0xD2, 0x88, },
	{ 0xE0, 0x01, },
	{ 0xE1, 0x04, },
	{ 0xE2, 0x41, },
	{ 0xE3, 0xD6, },
	{ 0xE4, 0x00, },
	{ 0xE5, 0x0C, },
	{ 0xE6, 0x0A, },
	{ 0xE7, 0x00, },
	{ 0xE8, 0x00, },
	{ 0xE9, 0x00, },
	{ 0xEE, 0x07, },
	{ 0xEF, 0x01, },
	{ 0x00, 0x1E, },
	{ 0x01, 0x1E, },
	{ 0x02, 0x0F, },
	{ 0x03, 0x10, },
	{ 0x04, 0x02, },
	{ 0x05, 0x00, },
	{ 0x06, 0xB0, },
	{ 0x07, 0x04, },
	{ 0x08, 0x0D, },
	{ 0x09, 0x0E, },
	{ 0x0A, 0x9C, },
	{ 0x0B, 0x04, },
	{ 0x0C, 0x05, },
	{ 0x0D, 0x0F, },
	{ 0x0E, 0x02, },
	{ 0x0F, 0x12, },
	{ 0x10, 0x02, },
	{ 0x11, 0x02, },
	{ 0x12, 0x00, },
	{ 0x13, 0x01, },
	{ 0x14, 0x05, },
	{ 0x15, 0x07, },
	{ 0x16, 0x05, },
	{ 0x17, 0x07, },
	{ 0x18, 0x01, },
	{ 0x19, 0x04, },
	{ 0x1A, 0x05, },
	{ 0x1B, 0x0C, },
	{ 0x1C, 0x2A, },
	{ 0x1D, 0x01, },
	{ 0x1E, 0x00, },
	{ 0x21, 0x00, },
	{ 0x22, 0x00, },
	{ 0x23, 0x00, },
	{ 0x25, 0x01, },
	{ 0x26, 0x00, },
	{ 0x27, 0x39, },
	{ 0x28, 0x7F, },
	{ 0x29, 0x08, },
	{ 0x30, 0x03, },
	{ 0x31, 0x00, },
	{ 0x32, 0x1A, },
	{ 0x33, 0x1A, },
	{ 0x34, 0x07, },
	{ 0x35, 0x07, },
	{ 0x36, 0x01, },
	{ 0x37, 0xFF, },
	{ 0x38, 0x36, },
	{ 0x39, 0x07, },
	{ 0x3A, 0x00, },
	{ 0x3E, 0xFF, },
	{ 0x3F, 0x00, },
	{ 0x40, 0x77, },
	{ 0x41, 0x40, },
	{ 0x42, 0x00, },
	{ 0x43, 0x30, },
	{ 0x44, 0xA0, },
	{ 0x45, 0x5C, },
	{ 0x46, 0x00, },
	{ 0x47, 0x00, },
	{ 0x48, 0x58, },
	{ 0x4A, 0x1E, },
	{ 0x4B, 0x1E, },
	{ 0x4C, 0x00, },
	{ 0x4D, 0x00, },
	{ 0x4E, 0xA0, },
	{ 0x4F, 0x80, },
	{ 0x50, 0x00, },
	{ 0x51, 0x00, },
	{ 0x52, 0x00, },
	{ 0x53, 0x00, },
	{ 0x54, 0x00, },
	{ 0x57, 0x80, },
	{ 0x59, 0x10, },
	{ 0x5A, 0x08, },
	{ 0x5B, 0x94, },
	{ 0x5C, 0xE8, },
	{ 0x5D, 0x08, },
	{ 0x5E, 0x3D, },
	{ 0x5F, 0x99, },
	{ 0x60, 0x45, },
	{ 0x61, 0x40, },
	{ 0x63, 0x2D, },
	{ 0x64, 0x02, },
	{ 0x65, 0x96, },
	{ 0x66, 0x00, },
	{ 0x67, 0x97, },
	{ 0x68, 0x01, },
	{ 0x69, 0xCD, },
	{ 0x6A, 0x01, },
	{ 0x6B, 0xB0, },
	{ 0x6C, 0x04, },
	{ 0x6D, 0x2C, },
	{ 0x6E, 0x01, },
	{ 0x6F, 0x32, },
	{ 0x71, 0x00, },
	{ 0x72, 0x01, },
	{ 0x73, 0x35, },
	{ 0x74, 0x00, },
	{ 0x75, 0x33, },
	{ 0x76, 0x31, },
	{ 0x77, 0x01, },
	{ 0x7C, 0x84, },
	{ 0x7D, 0x03, },
	{ 0x7E, 0x01, },
};

PAJ7620U2::PAJ7620U2(I2C* i2c, uint8_t slaveAddress)
{
	_I2c = i2c;
	_SlaveAddress = slaveAddress;
	_Initialized = false;
}

bool PAJ7620U2::Init()
{
	// Wake up.
	wait_us(700);
	RegisterWrite(0xEF, 0);						// R_RegBankSel
	wait_us(400);

	if (!RegisterWrite(0xEF, 0)) return false;	// R_RegBankSel

	uint16_t partId;
	if (!RegisterRead(0x00, (uint8_t*)&partId, sizeof(partId))) return false;	// PartID

	if (partId == 0x7620) {
		for (int i = 0; i < (int)(sizeof(_InitRegisterArray) / sizeof(_InitRegisterArray[0])); i++) {
			if (!RegisterWrite(_InitRegisterArray[i].Address, _InitRegisterArray[i].Value)) return false;
		}
	}

	if (!RegisterWrite(0xEF, 0)) return false;	// R_RegBankSel

	_Initialized = true;

	return true;
}

bool PAJ7620U2::GetGesture(PAJ7620U2::GestureFlag* flag)
{
	if (!_Initialized) return false;

	uint16_t data;
	if (!RegisterRead(0x43, (uint8_t*)&data, sizeof(data))) {	// IntFlag_1, IntFlag_2
		*flag = GESTURE_NONE;
		return false;
	}

	*flag = (GestureFlag)data;

	return true;
}
