#pragma once

class PAJ7620U2 {

private:
	I2C* _I2c;
	uint8_t _SlaveAddress;
	bool _Initialized;

	struct RegisterAddressValue {
		uint8_t Address;
		uint8_t Value;
	};
	static const RegisterAddressValue _InitRegisterArray[];

private:
	bool RegisterWrite(uint8_t address, uint8_t value);
	bool RegisterWrite(uint8_t address, const uint8_t* data, int dataSize);
	bool RegisterRead(uint8_t address, uint8_t* value);
	bool RegisterRead(uint8_t address, uint8_t* data, int dataSize);

public:
//	enum GestureFlag : uint16_t {	// [Warning] scoped enums only available with -std=c++11 or -std=gnu++11
	enum GestureFlag {
		GESTURE_NONE              = 0x0000,
		GESTURE_RIGHT             = 0x0001,
		GESTURE_LEFT              = 0x0002,
		GESTURE_UP                = 0x0004,
		GESTURE_DOWN              = 0x0008,
		GESTURE_FORWARD           = 0x0010,
		GESTURE_BACKWARD          = 0x0020,
		GESTURE_CLOCKWISE         = 0x0040,
		GESTURE_COUNTER_CLOCKWISE = 0x0080,
		GESTURE_WAVE              = 0x0100,
	};

public:
	PAJ7620U2(I2C* i2c, uint8_t address);
	bool Init();
	bool GetGesture(GestureFlag* flag);

};