#include "mbed.h"
#include "MjTextileSensor.h"

Serial pc(USBTX, USBRX);
I2C i2c(p28, p27);
MjTextileSensor sensor(&i2c, 0x84);

int main()
{
    pc.baud(57600);
    i2c.frequency(400000);

    uint8_t majorVersion;
    uint8_t minorVersion;
    sensor.GetVersion(&majorVersion, &minorVersion);
    pc.printf("Firmware version is %u.%u.\r\n", majorVersion, minorVersion);

    for (;;) {
        uint8_t values[10];
        int valuesCount = sensor.GetSensorValues(values, sizeof (values));
        if (valuesCount != 10) {
            continue;
        }

        for (int i = 0; i < valuesCount; i++) {
            pc.puts("\x1bM");
        }
        for (int i = 0; i < valuesCount; i++) {
            pc.printf("%3u ", values[i]);
            int j;
            for (j = 0; j < values[i] / 2; j++) {
                pc.putc('*');
            }
            for (; j < 255 / 2; j++) {
                pc.putc('_');
            }
            pc.puts("\r\n");
        }
    }
}
