#include "MjTextileSensor.h"
#include <string.h>

MjTextileSensor::MjTextileSensor(I2C* i2c, uint8_t address)
{
    this->i2c = i2c;
    this->address = address;
}

bool MjTextileSensor::GetVersion(uint8_t* majorVersion, uint8_t* minorVersion)
{
    char command = 0x00;
    i2c->write(address, &command, 1);

    char response[3];
    i2c->read(address, response, sizeof (response));
    if (response[0] != 0x80) {
        return false;
    }

    *minorVersion = response[1];
    *majorVersion = response[2];

    return true;
}
int MjTextileSensor::GetSensorValues(uint8_t* sensorValues, size_t sensorValuesSize)
{
    char response[11];
    i2c->read(address, response, sizeof (response));
    if (response[0] != 0xff) {
        memset(response, 0, sizeof (response));
        return 0;
    }

    int sensorValuesSizeActual = sensorValuesSize < 10 ? sensorValuesSize : 10;
    memcpy(sensorValues, &response[1], sensorValuesSizeActual);

    return sensorValuesSizeActual;
}
