#ifndef MJ_SI47XX_H
#define MJ_SI47XX_H

#include "mbed.h"

class MjSi47xx
{
public:
    enum FunctionType {
        FUNCTION_FM,
        FUNCTION_AM,
    };
    
    enum PropertyType {
        PROPERTY_RX_HARD_MUTE = 0x4001,
    };

public:
    MjSi47xx(I2C* i2c, uint8_t address, DigitalOut* rst_n);
    void reset();
    bool powerUp(FunctionType func);
    bool setProperty(PropertyType property, uint16_t value);
    bool getIntStatus(bool* stcInt);
    bool fmTuneFrequency(float frequency);
    bool fmTuneStatus(float* frequency, uint8_t* rssi = NULL, uint8_t* snr = NULL, uint8_t* multipath = NULL);
    bool amTuneFrequency(float frequency);
    bool amTuneStatus(float* frequency, uint8_t* rssi = NULL, uint8_t* snr = NULL);

private:
    I2C *i2c;
    uint8_t address;
    DigitalOut* rst_n;

    void writeCmd(uint8_t cmd, const uint8_t* argv = NULL, size_t argc = 0);
    void readRes(uint8_t* status, uint8_t *resv = NULL, size_t resc = 0);

};

#endif
