#ifndef MJ_LINE_SERIAL_H
#define MJ_LINE_SERIAL_H

#include "mbed.h"
#include <vector>
#include <queue>

namespace matsujirushi {

class MjLineSerial
{
public:
    MjLineSerial(RawSerial *serial);
    
    int putc(int c);
    int puts(const char *str);
    int printf(const char *format, ...);

    void attachReadLine(void (*func)(const char *str));
    void task();
    
    const char *txDelimiter;
    bool echo;
    
private:
    RawSerial *baseSerial;
    vector<char> rxBuffer;
    queue<char> txBuffer;
    void (*readLineFunc)(const char *str);
    
};

} // namespace matsujirushi

#endif
