/* Copyright (c) 2016 Takashi Matsuoka, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "MjSingleDigitDisplayTZ250A.h"

MjSingleDigitDisplayTZ250A::MjSingleDigitDisplayTZ250A(BusOut* data, DigitalOut* reset, DigitalOut* strobe)
    : MjSingleDigitDisplay(), _Data(data), _Reset(reset), _Strobe(strobe)
{
    _Data->write(0);
    _Reset->write(0);
    _Strobe->write(0);
}

void MjSingleDigitDisplayTZ250A::reset()
{
    _Reset->write(1);
    wait_ms(10);
    _Reset->write(0);
    wait_ms(600);
}

void MjSingleDigitDisplayTZ250A::writeHalf(uint8_t value)
{
    _Data->write(value);

    _Strobe->write(1);
    wait_ms(14);    // Tdly + Tbw

    _Strobe->write(0);
    wait_ms(1);     // Tsl
}

void MjSingleDigitDisplayTZ250A::write(uint8_t value)
{
    if (value < 36)
    {
        value = (value << 1 & 0x70 | 0x80) | (value & 0x07);
    }
    else if (value == 255)
    {
        value = 0xc4;   // Blank.
    }

    writeHalf(value & 0x0f);
    writeHalf(value >> 4);
}
