/* Copyright (c) 2016 Takashi Matsuoka, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include "MjLibrary.h"

/** EPSON LCD Single Digit Display TZ-250A
 *
 * http://www.originalmind.co.jp/useds/38871
 */
class MjSingleDigitDisplayTZ250A : MjSingleDigitDisplay
{
public:
    /** Constructor
     *
     * @param data DATA[0..3] pins
     * @param reset RESET pin
     * @param strobe STROBE pin
     *
     * @note
     *  We don't need to connect BUSY pin and TEST pin.
     */
    MjSingleDigitDisplayTZ250A(BusOut* data, DigitalOut* reset, DigitalOut* strobe);
    
    /** Display a numeric value
     *
     * @param value Numeric value
     */
    virtual void write(uint8_t value);

    /** Reset
     */
    void reset();

private:
    BusOut* _Data;
    DigitalOut* _Reset;
    DigitalOut* _Strobe;

    void writeHalf(uint8_t value);

};
