#include "mbed.h"
#include "MjHover.h"

using namespace matsujirushi;

Serial pc(USBTX, USBRX);

I2C i2c(p28, p27);
DigitalInOut hover_ts(p21);
DigitalInOut hover_reset_n(p22);

int main()
{
    pc.baud(115200);
    i2c.frequency(400000);
    
#if 0   // 1:MjHover, 0:MjHover2

    pc.printf("MjHover class.\r\n");
    
    MjHover hover(&i2c, 0x84, &hover_ts, &hover_reset_n);

    hover.begin();
    
    for (;;)
    {
        if (hover.getStatus() == false)
        {
            uint8_t event = hover.getEvent();
            hover.setRelease();
            
            const char* output_string = hover.getEventString(event);
            if (event != 0)
            {
                pc.printf("%02x:[%s]\r\n", event, hover.getEventString(event));
            }
        }
    }

#else

    pc.printf("MjHover2 class.\r\n");
    
    MjHover2 hover(&i2c, 0x84, &hover_ts, &hover_reset_n);
    hover.Reset();
    for (;;)
    {
        hover.Task();

        if (hover.SensorData.GestureInfoValid) printf("GestureInfo %d\r\n", hover.SensorData.GestureInfo);
//        if (hover.SensorData.TouchInfoValid) printf("TouchInfo %04x\r\n", hover.SensorData.TouchInfo);
//        if (hover.SensorData.XyzPositionValid) printf("XyzPosition %5u,%5u,%5u\r\n", hover.SensorData.XyzPosition.X, hover.SensorData.XyzPosition.Y, hover.SensorData.XyzPosition.Z);

    }

#endif
}
