#ifndef MJ_HOVER_H
#define MJ_HOVER_H

#include "mbed.h"

using namespace std;

namespace matsujirushi {

class MjHoverBase
{
public:
    MjHoverBase(I2C* i2c, uint8_t address, DigitalInOut* ts_n, DigitalInOut* reset_n);
    
    void Reset();
    
    bool DataAvailable() const
    {
        return this->ts_n->read() ? false : true;
    }
    
    bool WriteMessage(uint8_t id, const uint8_t* payload, uint8_t payloadSize);
    bool ReadMessage(uint8_t* id, uint8_t* payload, uint8_t payloadSize, uint8_t* readPayloadSize);
    
private:
    I2C *i2c;
    uint8_t address;
    DigitalInOut* ts_n;     // I/O Transfer Status
    DigitalInOut* reset_n;  // O   Master Clear#

    void BeginRead()
    {
        this->ts_n->output();
        this->ts_n->write(0);
    }
    void EndRead()
    {
        this->ts_n->input();
        wait_us(100);
    }

};

class MjHover : private MjHoverBase
{
public:
    MjHover(I2C* i2c, uint8_t address, DigitalInOut* ts_n, DigitalInOut* reset_n);
    void begin();
    void setRelease();
    bool getStatus();
    uint8_t getEvent();
    static const char* getEventString(uint8_t eventByte);
    
};

class MjHover2 : private MjHoverBase
{
public:
    enum GestureInfoType
    {
        FLICK_WEST_TO_EAST       ,
        FLICK_EAST_TO_WEST       ,
        FLICK_SOUTH_TO_NORTH     ,
        FLICK_NORTH_TO_SOUTH     ,
        EDGE_FLICK_WEST_TO_EAST  ,
        EDGE_FLICK_EAST_TO_WEST  ,
        EDGE_FLICK_SOUTH_TO_NORTH,
        EDGE_FLICK_NORTH_TO_SOUTH,
    };
    enum TouchInfoType
    {
        TOUCH_SOUTH       = 0x00000001,
        TOUCH_WEST        = 0x00000002,
        TOUCH_NORTH       = 0x00000004,
        TOUCH_EAST        = 0x00000008,
        TOUCH_CENTER      = 0x00000010,
        TAP_SOUTH         = 0x00000020,
        TAP_WEST          = 0x00000040,
        TAP_NORTH         = 0x00000080,
        TAP_EAST          = 0x00000100,
        TAP_CENTER        = 0x00000200,
        DOUBLE_TAP_SOUTH  = 0x00000400,
        DOUBLE_TAP_WEST   = 0x00000800,
        DOUBLE_TAP_NORTH  = 0x00001000,
        DOUBLE_TAP_EAST   = 0x00002000,
        DOUBLE_TAP_CENTER = 0x00004000,
    };
    struct XyzPositionType
    {
        uint16_t X;
        uint16_t Y;
        uint16_t Z;
    };
    struct
    {
        bool GestureInfoValid;
        GestureInfoType GestureInfo;

        bool TouchInfoValid;
        TouchInfoType TouchInfo;
        
        bool XyzPositionValid;
        XyzPositionType XyzPosition;
    }
    SensorData;
        

    MjHover2(I2C* i2c, uint8_t address, DigitalInOut* ts_n, DigitalInOut* reset_n);
    void Reset();
    void Task();
};

} // namespace matsujirushi

#endif





