#include "MjHover.h"

namespace matsujirushi {

MjHover::MjHover(I2C* i2c, uint8_t address, DigitalInOut* ts_n, DigitalInOut* reset_n) : MjHoverBase(i2c, address, ts_n, reset_n)
{
}

void MjHover::begin()
{
    MjHoverBase::Reset();
    wait_ms(1000);
}

void MjHover::setRelease()
{
}

bool MjHover::getStatus()
{
    if (MjHoverBase::DataAvailable())
    {
        return false;
    }
    return true;
}

uint8_t MjHover::getEvent()
{
    uint8_t id;
    uint8_t payload[255 - 4];
    uint8_t readPayloadSize;
    if (!MjHoverBase::ReadMessage(&id, payload, sizeof (payload), &readPayloadSize))
    {
        return 0x00;
    }
    
    uint8_t data;
    uint8_t event;
    for (int c = 4; c < 18; c++)
    {
        data = payload[c - 4];
        
        if (c == 10 && data > 1)
        {
            event = (0x01 << (data - 1)) | 0x20;
            return event;
        }
        if (c == 14 && data > 0x1f)
        {
            event = ((data & 0xe0) >> 5) | 0x40;
            return event;
        }
        if (c == 15 && data > 0)
        {
            event = ((data & 0x03) << 3) | 0x40;
            return event;
        }
    }
    
    return 0x00;
}

const char* MjHover::getEventString(uint8_t eventByte)
{
    switch (eventByte)
    {
    case 0x22:
        return "Right Swipe";
    case 0x24:
        return "Left Swipe";
    case 0x28:
        return "Up Swipe";
    case 0x30:
        return "Down Swipe";
    case 0x41:
        return "Tap South";
    case 0x42:
        return "Tap West";
    case 0x50:
        return "Tap Center";
    case 0x48:
        return "Tap East";
    case 0x44:
        return "Tap North";
    default:
        return "";
    }
}

} // namespace matsujirushi

