#include "MjAD520x.h"

MjAD520x::MjAD520x(PinName mosi, PinName miso, PinName sclk, PinName cs_n, int terminalResistance)
    : HwSpi(mosi, miso, sclk), HwCs_n(cs_n, 1)
{
    TerminalResistance = terminalResistance;

    HwSpi.format(11, 0);
    HwSpi.frequency(1000000);
}

void MjAD520x::write(int channel, int resistance)
{
    write_u8(channel, resistance <= TerminalResistance ? resistance * 255 / TerminalResistance : 255);
}

void MjAD520x::write_u8(int channel, uint8_t value)
{
    HwCs_n.write(0);
    wait_us(1);

    HwSpi.write(channel << 8 | value);

    HwCs_n.write(1);
    wait_us(1);
}

