#ifndef LINE_SERIAL_H
#define LINE_SERIAL_H

#include "mbed.h"

class LineSerial : public Serial
{
public:
    LineSerial(PinName tx, PinName rx, const char *name = NULL);
    virtual ~LineSerial();

    void allocateReadBuffer(size_t size);
    
    void attachReadLine(void (*func)(const char* str));
    
    void task();

private:
    char *readBuffer;
    size_t readBufferSize;
    size_t readBufferCount;

    void (*readLineFunc)(const char* data);

    bool appendReadBuffer(char data);
    bool removeReadBuffer();

};

#endif