#include "mbed.h"

Serial pc(USBTX, USBRX);


DigitalOut CSn(dp28);
DigitalOut CLK(dp26);
DigitalIn DO(dp25);

int main() {
    
    // Initial.
    CSn = 1;
    CLK = 1;

    pc.baud(115200);
    pc.printf("Ready.\r\n");

    for (;;)
    {
        CSn = 0;
        wait_us(1);

        uint16_t data = 0;
        for (int i = 0; i < 16; i++)
        {
            CLK = 0;
            wait_us(1);
            CLK = 1;
            wait_us(1);
            
            data <<= 1;
            if (DO.read()) data |= 1;
        }
        CSn = 1;
        
        uint16_t angular = data >> 6;
        uint16_t status = (data >> 1) & 0x1f;
        pc.printf("%03x %02x\r\n", angular, status);
        
        wait(0.2);
    }
}

